package com.biz.crm.admin.web.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.ConsumerTerminalMappingDto;
import com.biz.crm.admin.web.repository.ConsumerTerminalMappingReportRepository;
import com.biz.crm.admin.web.service.ConsumerTerminalMappingReportService;
import com.biz.crm.admin.web.vo.ConsumerTerminalMappingReportVo;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * 消费者关联终端报表service实现
 * @author songjingen
 */
@Service
public class ConsumerTerminalMappingReportServiceImpl implements ConsumerTerminalMappingReportService {

  @Resource
  private ConsumerTerminalMappingReportRepository consumerTerminalMappingReportRepository;

  /**
   * 消费者关联终端报表分页查询
   * @param pageable
   * @param dto
   * @return
   */
  @Override
  public Page<ConsumerTerminalMappingReportVo> findByConditions(Pageable pageable, ConsumerTerminalMappingDto dto) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if(dto == null) {
      dto = new ConsumerTerminalMappingDto();
    }
    Page<ConsumerTerminalMappingReportVo> page = consumerTerminalMappingReportRepository.findByConditions(pageable, dto);
    return page;
  }

  /**
   * 消费者关联终端
   * @param dto
   * @return
   */
  @Override
  public List<ConsumerTerminalMappingReportVo> findByConditions(ConsumerTerminalMappingDto dto) {
    if(dto == null) {
      dto = new ConsumerTerminalMappingDto();
    }
    List<ConsumerTerminalMappingReportVo> list = consumerTerminalMappingReportRepository.findByConditions(dto);
    return list;
  }
}
