package com.biz.crm.admin.web.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.ContractSignReportDto;
import com.biz.crm.admin.web.repository.ContractSignReportVoRepository;
import com.biz.crm.admin.web.service.ContractSignReportVoService;
import com.biz.crm.admin.web.vo.ContractSignReportVo;
import com.biz.crm.cps.business.participator.sdk.vo.ParticipatorTagVo;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.stream.Collectors;

/**
 * 合同签署报表service实现
 * @author songjingen
 */
@Service
public class ContractSignReportVoServiceImpl implements ContractSignReportVoService {

  @Autowired
  private ContractSignReportVoRepository contractSignReportVoRepository;

  /**
   * 根据查询条件分页查询列表
   * @param pageable
   * @param dto
   * @return
   */
  @Override
  public Page<ContractSignReportVo> findByConditions(Pageable pageable, ContractSignReportDto dto) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (dto == null) {
      dto = new ContractSignReportDto();
    }
    Page<ContractSignReportVo> list = this.contractSignReportVoRepository.findByConditions(pageable, dto);
    list.getRecords().forEach(item ->{
      if (!CollectionUtils.isEmpty(item.getParticipatorTagVos())) {
        item.setTerminalTag(item.getParticipatorTagVos()
                .stream()
                .map(ParticipatorTagVo::getTagDescription)
                .collect(Collectors.joining("，")));
      }
    });
    return list;
  }
}
