package com.biz.crm.admin.web.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.service.DealerReportService;
import com.biz.crm.admin.web.service.RewardRelParticipatorVoService;
import com.biz.crm.cps.business.participator.local.repository.DealerRepository;
import com.biz.crm.cps.business.participator.sdk.dto.DealerDto;
import com.biz.crm.cps.business.participator.sdk.service.ParticipatorTagVoService;
import com.biz.crm.cps.business.participator.sdk.vo.DealerVo;
import com.biz.crm.cps.business.participator.sdk.vo.ParticipatorTagVo;
import com.biz.crm.cps.business.reward.cost.sdk.common.CostConstant;
import com.biz.crm.cps.business.reward.redpacket.sdk.common.constant.RedPacketConstant;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelParticipatorVo;
import com.biz.crm.cps.business.reward.sdk.vo.RewardTypeStatisticsVo;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 分利经销商报表service实现
 *
 * @author zengxingwang
 */
@Service
public class DealerReportServiceImpl implements DealerReportService {

  @Autowired
  private DealerRepository dealerRepository;

  @Autowired
  private RewardRelParticipatorVoService rewardRelParticipatorVoService;

  @Autowired
  private ParticipatorTagVoService participatorTagVoService;

  @Override
  public Page<DealerVo> findByConditions(DealerDto dealerDto, Pageable pageable) {
    /**
     * 分页查询终端信息
     * 将查询出的信息拷贝到返回vo
     * 收集查询信息的code集合
     * 查询终端信息的奖励结果
     * 将奖励结果按参与者code分组
     * 将奖励结果拼装回返回vo
     */
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    Page<DealerVo> dealers = dealerRepository.findByConditions(pageable, dealerDto);
    List<String> codeList = dealers.getRecords().stream()
        .map(DealerVo::getCustomerCode)
        .collect(Collectors.toList());
    List<RewardRelParticipatorVo> rewardRelParticipatorVoList = this.rewardRelParticipatorVoService.findByParticipatorCodes(codeList);
    if (CollectionUtils.isEmpty(rewardRelParticipatorVoList)) {
      return dealers;
    }
    //标签
    Map<String, List<ParticipatorTagVo>> participatorTagMap = new HashMap<>();
    List<ParticipatorTagVo> participatorTagList = this.participatorTagVoService.findByParticipatorCodes(codeList);
    if (!CollectionUtils.isEmpty(participatorTagList)) {
      participatorTagMap = participatorTagList.stream().collect(Collectors.groupingBy(ParticipatorTagVo::getParticipatorCode));
    }
    Map<String, List<RewardRelParticipatorVo>> codeMapVoList = rewardRelParticipatorVoList.stream().collect(Collectors.groupingBy(RewardRelParticipatorVo::getParticipatorCode));
    for (DealerVo reportVo : dealers.getRecords()) {
      //赋值标签
      List<ParticipatorTagVo> tags = participatorTagMap.get(reportVo.getCustomerCode());
      if(!CollectionUtils.isEmpty(tags)){
        String participatorTag = tags.stream().map(tag -> tag.getTagDescription()).collect(Collectors.joining(";"));
        reportVo.setTagDescription(participatorTag);
      }
     //赋值分利信息
      List<RewardRelParticipatorVo> rewardRelParticipatorVos = codeMapVoList.get(reportVo.getCustomerCode());
      if (CollectionUtils.isEmpty(rewardRelParticipatorVos)) {
        continue;
      }
      RewardRelParticipatorVo rewardRelParticipatorVo = rewardRelParticipatorVos.get(0);
      List<RewardTypeStatisticsVo> rewardTypeStatisticsVos = rewardRelParticipatorVo.getRewardTypeStatisticsVos();
      for (RewardTypeStatisticsVo rewardTypeStatisticsVo : rewardTypeStatisticsVos) {
        String key = rewardTypeStatisticsVo.getKey();
        if (CostConstant.COST_KEY.equals(key)) {
          reportVo.setAccruingCost(rewardTypeStatisticsVo.getAmount());
        } else if ("integral".equals(key)) {
          reportVo.setAccruingIntegral(rewardTypeStatisticsVo.getAmount());
        } else if (RedPacketConstant.REDPACKAGE_KEY.equals(key)) {
          reportVo.setAccruingRedPacket(rewardTypeStatisticsVo.getAmount());
        }
        reportVo.setAccruingCash(BigDecimal.ZERO);
      }
    }
    return dealers;
  }
}
