package com.biz.crm.admin.web.service.internal;

import com.biz.crm.admin.web.service.ParticipatorReportService;
import com.biz.crm.admin.web.vo.ParticipatorReportVo;
import com.biz.crm.cps.business.agreement.sdk.dto.LoginUserAgreementDto;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementVoService;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.consumer.sdk.service.ConsumerVoService;
import com.biz.crm.cps.business.consumer.sdk.vo.ConsumerVo;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.participator.sdk.service.DealerVoService;
import com.biz.crm.cps.business.participator.sdk.service.TerminalVoService;
import com.biz.crm.cps.business.participator.sdk.vo.DealerVo;
import com.biz.crm.cps.business.participator.sdk.vo.TerminalVo;
import com.biz.crm.cps.business.reward.cost.local.entity.CostDealerEntity;
import com.biz.crm.cps.business.reward.cost.local.entity.CostTerminalEntity;
import com.biz.crm.cps.business.reward.cost.local.service.CostDealerService;
import com.biz.crm.cps.business.reward.cost.local.service.CostTerminalService;
import com.biz.crm.cps.business.reward.integral.local.entity.IntegralEntity;
import com.biz.crm.cps.business.reward.integral.local.service.IntegralService;
import com.biz.crm.cps.business.reward.redpacket.local.entity.RedPacketEntity;
import com.biz.crm.cps.business.reward.redpacket.local.service.RedPacketService;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordStatisticsDto;
import com.biz.crm.cps.external.barcode.sdk.service.ScanCodeRecordVoService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;

/**
 * 参与者分利报表service实现
 * @Author: zengxingwang
 * @Date: 2021/9/17 15:08
 */
@Service
public class ParticipatorReportServiceImpl implements ParticipatorReportService {

  @Autowired
  private RedPacketService redPacketService;
  @Autowired
  private IntegralService integralService;
  @Autowired
  private CostDealerService costDealerService;
  @Autowired
  private CostTerminalService costTerminalService;
  @Autowired
  private ScanCodeRecordVoService scanCodeRecordVoService;
  @Autowired
  private AgreementVoService agreementVoService;
  @Autowired
  private DealerVoService dealerVoService;
  @Autowired
  private TerminalVoService terminalVoService;
  @Autowired
  private ConsumerVoService consumerVoService;
  /**
   * 分利参与者分利报表
   * @param participatorCode
   * @param participatorType
   * @return
   */
  @Override
  public ParticipatorReportVo findByParticipatorCodeAndType(String participatorCode, String participatorType) {
    if(StringUtils.isBlank(participatorCode) || StringUtils.isBlank(participatorType)){
      return null;
    }
    ParticipatorReportVo vo = new ParticipatorReportVo();
    //现金
    vo.setCashTotal(BigDecimal.ZERO);
    vo.setCashAvailable(BigDecimal.ZERO);
    //累计销售订单数
    vo.setOrderTotal(BigDecimal.ZERO);
    //累计销售订单金额
    vo.setOrderAmountTotal(BigDecimal.ZERO);
    if(ParticipatorTypeEnum.DEALER.getDictCode().equals(participatorType)){
      DealerVo dealerVo = dealerVoService.findByCustomerCode(participatorCode);
      if(dealerVo != null){
        vo.setAccessTime(dealerVo.getCreateTime());
      }
    }
    if(ParticipatorTypeEnum.TERMINAL.getDictCode().equals(participatorType)){
      List<TerminalVo> terminals = terminalVoService.findByTerminalCodes(Arrays.asList(participatorCode));
      if(!CollectionUtils.isEmpty(terminals)){
        vo.setAccessTime(terminals.get(0).getCreateTime());
      }
    }
    if(ParticipatorTypeEnum.CONSUMER.getDictCode().equals(participatorType)){
      ConsumerVo consumerVo = consumerVoService.findByConsumerCode(participatorCode);
      if(consumerVo != null){
        vo.setAccessTime(consumerVo.getCreateTime());
      }
    }

    //红包
    RedPacketEntity redPacket = redPacketService.findByParticipatorCode(participatorCode);
    if(redPacket != null){
      vo.setRedPacketTotal(redPacket.getAccruingRedPacket() == null ? BigDecimal.ZERO : redPacket.getAccruingRedPacket());
      vo.setRedPacketAvailable(redPacket.getBalance() == null ? BigDecimal.ZERO : redPacket.getBalance());
    }else {
      vo.setRedPacketTotal(BigDecimal.ZERO);
      vo.setRedPacketAvailable(BigDecimal.ZERO);
    }

    //费用
    //经销商费用
    if(ParticipatorTypeEnum.DEALER.getDictCode().equals(participatorType)){
      CostDealerEntity dealer = costDealerService.findByDealerCode(participatorCode);
      if(dealer != null){
        vo.setCostTotal(dealer.getTotalAmount() == null ? BigDecimal.ZERO : dealer.getTotalAmount());
        vo.setCostAvailable(dealer.getUnBilledFee() == null ? BigDecimal.ZERO : dealer.getUnBilledFee());
      }else {
        vo.setCostTotal(BigDecimal.ZERO);
        vo.setCostAvailable(BigDecimal.ZERO);
      }
    }
    if(ParticipatorTypeEnum.TERMINAL.getDictCode().equals(participatorType)){
      CostTerminalEntity terminal = costTerminalService.findByTerminalCode(participatorCode);
      if(terminal != null){
        vo.setCostTotal(terminal.getTotalAmount() == null ? BigDecimal.ZERO : terminal.getTotalAmount());
        vo.setCostAvailable(terminal.getUnAuditFee() == null ? BigDecimal.ZERO : terminal.getUnAuditFee());
      }else {
        vo.setCostTotal(BigDecimal.ZERO);
        vo.setCostAvailable(BigDecimal.ZERO);
      }
    }

    //积分
    IntegralEntity integral = integralService.findByParticipatorCode(participatorCode);
    if(integral != null){
      vo.setIntegralTotal(integral.getAccruingIntegral() == null ? BigDecimal.ZERO : integral.getAccruingIntegral());
      vo.setIntegralAvailable(integral.getBalance() == null ? BigDecimal.ZERO : integral.getBalance());
    }else {
      vo.setIntegralTotal(BigDecimal.ZERO);
      vo.setIntegralAvailable(BigDecimal.ZERO);
    }

    //协议
    LoginUserAgreementDto agreementDto = new LoginUserAgreementDto();
    if(ParticipatorTypeEnum.DEALER.getDictCode().equals(participatorType)){
      agreementDto.setCustomerCode(participatorCode);
    }
    if(ParticipatorTypeEnum.TERMINAL.getDictCode().equals(participatorType)){
      agreementDto.setTerminalCode(participatorCode);
    }
    List<AgreementVo> agreemnts = agreementVoService.findByConditions(agreementDto);
    if(!CollectionUtils.isEmpty(agreemnts)){
      vo.setAgreementTotal(new BigDecimal(agreemnts.size()));
    }else {
      vo.setAgreementTotal(BigDecimal.ZERO);
    }

    //扫码
    ScanCodeRecordStatisticsDto dto = new ScanCodeRecordStatisticsDto();
    dto.setScanParticipatorCode(participatorCode);
    Integer integer = scanCodeRecordVoService.countByScanCodeRecordDto(dto);
    vo.setScanTotal(integer == null ? BigDecimal.ZERO : new BigDecimal(integer));
    return vo;
  }
}
