package com.biz.crm.admin.web.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.ParticipatorRewardDto;
import com.biz.crm.admin.web.repository.ParticipatorRewardVoRepository;
import com.biz.crm.admin.web.service.ParticipatorRewardVoService;
import com.biz.crm.admin.web.vo.ParticipatorRewardVo;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/**
 * 参与者分利明细报表service实现
 * @Author: zengxingwang
 * @Date: 2021/9/24 10:44
 */
@Service
public class ParticipatorRewardVoServiceImpl implements ParticipatorRewardVoService {

  @Autowired
  private ParticipatorRewardVoRepository participatorRewardVoRepository;

  /**
   * 多条件分页查询
   * @param pageable
   * @param dto
   * @return
   */
  @Override
  public Page<ParticipatorRewardVo> findByConditions(Pageable pageable, ParticipatorRewardDto dto) {
    if(dto == null || StringUtils.isBlank(dto.getCode())){
      return new Page<>();
    }
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    return participatorRewardVoRepository.findByConditions(pageable, dto);
  }
}
