package com.biz.crm.admin.web.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.QuantifyTaskReportDto;
import com.biz.crm.admin.web.repository.QuantifyPolicyReportRepository;
import com.biz.crm.admin.web.service.QuantifyPolicyReportService;
import com.biz.crm.admin.web.service.RewardRelTriggerObjectVoService;
import com.biz.crm.admin.web.service.RewardTypeStatisticsVoService;
import com.biz.crm.admin.web.vo.MaterialRangeVo;
import com.biz.crm.admin.web.vo.ProfitProductVo;
import com.biz.crm.admin.web.vo.QuantifyStatisticsReportVo;
import com.biz.crm.admin.web.vo.QuantifyTaskReportVo;
import com.biz.crm.cps.bisiness.policy.quantify.sdk.constant.QuantifyConstant;
import com.biz.crm.cps.bisiness.policy.quantify.sdk.constant.QuantifyTaskStatusEnum;
import com.biz.crm.cps.bisiness.policy.quantify.sdk.enums.QuantityTaskTypeEnums;
import com.biz.crm.cps.business.participator.sdk.vo.ParticipatorTagVo;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.entity.QuantifyTask;
import com.biz.crm.cps.business.reward.sdk.common.enums.RewardTypeEnum;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelTriggerObjectVo;
import com.biz.crm.cps.business.reward.sdk.vo.RewardTypeStatisticsVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 扫码记录报表service实现类
 *
 * @author songjingen
 */
@Service
public class QuantifyPolicyReportServiceImpl implements QuantifyPolicyReportService {

  @Autowired
  private QuantifyPolicyReportRepository quantifyPolicyReportRepository;

  @Autowired
  private RewardTypeStatisticsVoService rewardTypeStatisticsVoService;

  @Autowired
  private RewardRelTriggerObjectVoService rewardRelTriggerObjectVoService;

  @Override
  public QuantifyStatisticsReportVo findQuantifyStatisticsReportByTenant() {
    QuantifyStatisticsReportVo quantifyStatisticsReportVo = new QuantifyStatisticsReportVo();
    //获取进行中任务数量
    quantifyStatisticsReportVo.setExecutionTaskNumbers(quantifyPolicyReportRepository.findQuantifyStatisticsReportByTenant(QuantifyTaskStatusEnum.STATUS_DOING.getCode(), TenantUtils.getTenantCode()));
    //获取已完成任务数量
    quantifyStatisticsReportVo.setFinishTaskNumbers(quantifyPolicyReportRepository.findQuantifyStatisticsReportByTenant(QuantifyTaskStatusEnum.STATUS_COMPLETE.getCode(), TenantUtils.getTenantCode()));
    //获取分利信息
    quantifyStatisticsReportVo.setRewardTypeStatisticsVos(rewardTypeStatisticsVoService.findByTenantCodeAndTriggerAction(TenantUtils.getTenantCode(), QuantifyConstant.QUANTIFY_ACTION_NAME));
    return quantifyStatisticsReportVo;
  }

  @Override
  public Page<QuantifyTaskReportVo> findByConditions(Pageable pageable, QuantifyTaskReportDto dto) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (dto == null) {
      dto = new QuantifyTaskReportDto();
    }
    Page<QuantifyTaskReportVo> page = this.quantifyPolicyReportRepository.findByConditions(pageable, dto);
    if (CollectionUtils.isEmpty(page.getRecords())) {
      return page;
    }
    //获取业务单号集合
    List<String> businessCodes = page.getRecords().stream().map(QuantifyTask::getBusinessCode).collect(Collectors.toList());
    //根据业务单号集合获取分利信息集合
    List<RewardRelTriggerObjectVo> rewardRelTriggerObjectVos = rewardRelTriggerObjectVoService.findByTriggerActionAndTriggerObjects(QuantifyConstant.QUANTIFY_ACTION_NAME, businessCodes);
    Map<String, List<RewardTypeStatisticsVo>> map = Maps.newHashMap();
    rewardRelTriggerObjectVos.forEach(vo -> {
      map.put(vo.getTriggerObject(), vo.getRewardTypeStatisticsVos());
    });

    page.getRecords().forEach(reportVo -> {
      //为每个记录设置分利信息
      if (StringUtils.isNotBlank(reportVo.getBusinessCode()) && map.containsKey(reportVo.getBusinessCode())) {
        reportVo.setRewardTypeStatisticsVos(map.get(reportVo.getBusinessCode()));
      }
      //为每个记录设置终端标签信息
      if (!CollectionUtils.isEmpty(reportVo.getParticipatorTagVos())) {
        reportVo.setParticipatorTagStr(reportVo.getParticipatorTagVos()
                .stream()
                .map(ParticipatorTagVo::getTagDescription)
                .collect(Collectors.joining("，")));
      }
      if (!CollectionUtils.isEmpty(reportVo.getProfitProductVos())) {
        reportVo.setProfitProductStr(reportVo.getProfitProductVos()
                .stream()
                .map(ProfitProductVo::getMaterialName)
                .collect(Collectors.joining("，")));
      }
      if (!CollectionUtils.isEmpty(reportVo.getMaterialRangeVos())) {
        reportVo.setMaterialRangeStr(reportVo.getMaterialRangeVos()
                .stream()
                .map(MaterialRangeVo::getMaterialName)
                .collect(Collectors.joining("，")));
      }
    });
    //完成率
    page.getRecords().stream().forEach(item ->{
      //
      Map<String, BigDecimal> statisticsMap = new HashMap<>();
      item.getRewardTypeStatisticsVos().stream().forEach(vo ->{
        statisticsMap.put(vo.getKey(), vo.getAmount());
      });

      BigDecimal completionRate = item.getSaleTarget() == null || item.getSaleActual() == null ? BigDecimal.ZERO : item.getSaleActual().divide(item.getSaleTarget(), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
      item.setCompletionRate(completionRate);
      item.setRedpacket(statisticsMap.get(RewardTypeEnum.REDPACKET.getKey()) == null ? BigDecimal.ZERO : statisticsMap.get(RewardTypeEnum.REDPACKET.getKey()));
      item.setCost(statisticsMap.get(RewardTypeEnum.COST.getKey()) == null ? BigDecimal.ZERO : statisticsMap.get(RewardTypeEnum.COST.getKey()));
      item.setIntegral(statisticsMap.get(RewardTypeEnum.INTEGRAL.getKey()) == null ? BigDecimal.ZERO : statisticsMap.get(RewardTypeEnum.INTEGRAL.getKey()));
      item.setGift(statisticsMap.get(RewardTypeEnum.GIFT.getKey()) == null ? BigDecimal.ZERO : statisticsMap.get(RewardTypeEnum.GIFT.getKey()));
    });
    //todo,暂时直接取值按照任务类型排序 (月。季度，半年，年)
    ArrayList<QuantifyTaskReportVo> orderList = new ArrayList<>();
    Map<String, List<QuantifyTaskReportVo>> collect = page.getRecords().stream().collect(Collectors.groupingBy(QuantifyTaskReportVo::getTaskType));
    if (!CollectionUtils.isEmpty(collect.get(QuantityTaskTypeEnums.MONTH.getCode()))) {
      orderList.addAll(collect.get(QuantityTaskTypeEnums.MONTH.getCode()));
    }
    if (!CollectionUtils.isEmpty(collect.get(QuantityTaskTypeEnums.SEASON.getCode()))) {
      orderList.addAll(collect.get(QuantityTaskTypeEnums.SEASON.getCode()));
    }
    if (!CollectionUtils.isEmpty(collect.get(QuantityTaskTypeEnums.HALF_YEAR.getCode()))) {
      orderList.addAll(collect.get(QuantityTaskTypeEnums.HALF_YEAR.getCode()));
    }
    if (!CollectionUtils.isEmpty(collect.get(QuantityTaskTypeEnums.YEAR.getCode()))) {
      orderList.addAll(collect.get(QuantityTaskTypeEnums.YEAR.getCode()));
    }
    page.setRecords(orderList);
    return page;
  }
}
