package com.biz.crm.admin.web.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.repository.RewardActivityReceiveVoRepository;
import com.biz.crm.admin.web.service.RewardActivityReceiveVoService;
import com.biz.crm.cps.business.activity.actual.sdk.dto.RewardActivityReceiveDto;
import com.biz.crm.cps.business.activity.actual.sdk.vo.RewardActivityReceiveVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.text.ParseException;
import java.text.SimpleDateFormat;

/**
 * 活动奖励中奖接口实现
 * @Author: zengxingwang
 * @Date: 2021/10/20 15:03
 */
@Service
public class RewardActivityReceiveVoServiceImpl implements RewardActivityReceiveVoService {

  @Autowired
  private RewardActivityReceiveVoRepository rewardActivityReceiveVoRepository;
  /**
   * 条件查询中奖列表
   * @param dto
   * @param pageable
   * @return
   */
  @Override
  public Page<RewardActivityReceiveVo> findByConditions(RewardActivityReceiveDto dto, Pageable pageable) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    dto.setTenantCode(TenantUtils.getTenantCode());
    try {
      //格式化时间
      SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
      if (StringUtils.isNotBlank(dto.getStartTime())) {
        dto.setStartTime(DateFormatUtils.format(simpleDateFormat.parse(dto.getStartTime()), "yyyy-MM-dd 00:00:00"));
      }
      if (StringUtils.isNotBlank(dto.getEndTime())) {
        dto.setEndTime(DateFormatUtils.format(simpleDateFormat.parse(dto.getEndTime()), "yyyy-MM-dd 23:59:59"));
      }
    } catch (ParseException e) {
      e.printStackTrace();
    }
    Page<RewardActivityReceiveVo> receiveVoPage = rewardActivityReceiveVoRepository.findByConditions(dto, pageable);
    if(CollectionUtils.isEmpty(receiveVoPage.getRecords())){
      return new Page<>();
    }
    return receiveVoPage;
  }

  public static void main(String[] args) throws ParseException {
    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    String format = DateFormatUtils.format(simpleDateFormat.parse("2022-01-01 14:14"), "yyyy-MM-dd 00:00:00 ");
    System.out.println(format);
  }
}
