package com.biz.crm.admin.web.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.RewardGiftDetailReportDto;
import com.biz.crm.admin.web.repository.RewardGiftDetailReportRepository;
import com.biz.crm.admin.web.service.RewardGiftDetailReportService;
import com.biz.crm.admin.web.vo.RewardGiftDetailReportVo;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.participator.sdk.service.ParticipatorTagVoService;
import com.biz.crm.cps.business.participator.sdk.vo.ParticipatorTagVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 奖励赠品流水明细报表接口实现
 *
 * @author songjingen
 */
@Service
@Slf4j
public class RewardGiftDetailReportServiceImpl implements RewardGiftDetailReportService {

  @Autowired
  private RewardGiftDetailReportRepository rewardGiftDetailReportRepository;
  @Autowired
  private ParticipatorTagVoService participatorTagVoService;

  /**
   * 奖励赠品流水明细报表分页查询
   *
   * @param pageable 分页参数
   * @param dto      查询条件
   * @return
   */
  @Override
  public Page<RewardGiftDetailReportVo> findByConditions(Pageable pageable, RewardGiftDetailReportDto dto) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (dto == null) {
      dto = new RewardGiftDetailReportDto();
    }
    if (StringUtils.isBlank(dto.getParticipatorType())) {
      return null;
    }
    Page<RewardGiftDetailReportVo> conditions = this.rewardGiftDetailReportRepository.findByConditions(pageable, dto);
    List<RewardGiftDetailReportVo> records = conditions.getRecords();
    if (CollectionUtils.isEmpty(records)) {
      return null;
    }
    //设置标签信息
    if (!StringUtils.equals(dto.getParticipatorType(), ParticipatorTypeEnum.CONSUMER.getDictCode())) {
      this.buildInfos(records);
    }
    return conditions;
  }

  /**
   * 组装关联数据
   *
   * @param records
   */
  private void buildInfos(List<RewardGiftDetailReportVo> records) {
    //查询标签
    Map<String, List<ParticipatorTagVo>> participatorTagMap = new HashMap<>();
    List<String> participatorCodes = records.stream().map(RewardGiftDetailReportVo::getParticipatorCode).collect(Collectors.toList());
    List<ParticipatorTagVo> participatorTagList = this.participatorTagVoService.findByParticipatorCodes(participatorCodes);
    if (!CollectionUtils.isEmpty(participatorTagList)) {
      participatorTagMap = participatorTagList.stream().collect(Collectors.groupingBy(ParticipatorTagVo::getParticipatorCode));
    }
    for (RewardGiftDetailReportVo entity : records) {
      //赋值标签
      List<ParticipatorTagVo> tags = participatorTagMap.get(entity.getParticipatorCode());
      if(!CollectionUtils.isEmpty(tags)){
        String participatorTag = tags.stream().map(tag -> tag.getTagDescription()).collect(Collectors.joining(";"));
        entity.setTags(participatorTag);
      }
    }
  }

}
