package com.biz.crm.admin.web.service.internal;

import com.biz.crm.admin.web.service.RewardRelAgreementVoService;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardRelAgreementServiceObserver;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelAgreementItemVo;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelAgreementVo;
import com.biz.crm.cps.business.reward.sdk.vo.RewardTypeStatisticsVo;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author hecheng
 * @description: 分利协议汇总奖励报表
 * <pre>
 *   汇总各个具体奖励模块参与者的模版编码奖励信息
 *   包含 模版编码和其对应的奖励汇总
 * </pre>
 * @date 2021/8/24 下午6:57
 */
@Service
public class RewardRelAgreementVoServiceImpl implements RewardRelAgreementVoService {

  @Autowired(required = false)
  private List<RewardRelAgreementServiceObserver> rewardRelAgreementServiceObservers;

  /**
   * 1.获取每个奖励模块的奖励信息 2.汇总后按合同分类
   *
   * @param participatorCode
   * @param templateCodes
   * @return
   */
  @Override
  public List<RewardRelAgreementVo> findByParticipatorCodeAndTemplateCodes(String participatorCode, List<String> templateCodes) {
    if (CollectionUtils.isEmpty(templateCodes) || StringUtils.isBlank(participatorCode) || CollectionUtils.isEmpty(rewardRelAgreementServiceObservers)) {
      return null;
    }
    List<RewardRelAgreementVo> relList = Lists.newArrayList();

    //1.获取每个奖励模块的奖励信息
    List<RewardRelAgreementItemVo> list = Lists.newArrayList();
    for (RewardRelAgreementServiceObserver rewardServiceObserver : rewardRelAgreementServiceObservers) {
      List<RewardRelAgreementItemVo> itemRels = rewardServiceObserver.onRequestRewardRelAgreementItems(participatorCode, templateCodes);
      if (!CollectionUtils.isEmpty(itemRels)) {
        list.addAll(itemRels);
      }
    }
    //2.汇总后按合同分类
    Map<String, List<RewardRelAgreementItemVo>> relMap = list.stream().filter(item -> Objects.nonNull(item.getTemplateCode()))
            .collect(Collectors.groupingBy(RewardRelAgreementItemVo::getTemplateCode));
    for (Map.Entry<String, List<RewardRelAgreementItemVo>> entry : relMap.entrySet()) {
      RewardRelAgreementVo vo = new RewardRelAgreementVo();
      vo.setTemplateCode(entry.getKey());
      List<RewardRelAgreementItemVo> itemVos = entry.getValue();
      List<RewardTypeStatisticsVo> rewardTypeStatisticsVos = itemVos.stream().map(RewardRelAgreementItemVo::getRewardStatisticsVo).collect(Collectors.toList());
      vo.setRewardTypeStatisticsVos(rewardTypeStatisticsVos);
      relList.add(vo);
    }

    return relList;
  }
}
