package com.biz.crm.admin.web.service.internal;

import com.biz.crm.admin.web.service.RewardRelParticipatorVoService;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardRelParticipatorServiceObserver;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelParticipatorItemVo;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelParticipatorVo;
import com.biz.crm.cps.business.reward.sdk.vo.RewardTypeStatisticsVo;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author hecheng
 * @description: 参与者奖励报表service实现
 * @date 2021/8/18 上午11:03
 */
@Service
public class RewardRelParticipatorVoServiceImpl implements RewardRelParticipatorVoService {

  @Autowired(required = false)
  private List<RewardRelParticipatorServiceObserver> rewardRelParticipatorServiceObserverList;

  /**
   * 1.获取每个奖励模块的奖励信息 2.汇总后按参与者分类
   *
   * @param participatorCodes
   * @return
   */
  @Override
  public List<RewardRelParticipatorVo> findByParticipatorCodes(List<String> participatorCodes) {
    if (CollectionUtils.isEmpty(participatorCodes) || CollectionUtils.isEmpty(rewardRelParticipatorServiceObserverList)) {
      return null;
    }
    List<RewardRelParticipatorVo> relList = Lists.newArrayList();
    //1获取每个奖励模块的奖励信息
    List<RewardRelParticipatorItemVo> list = Lists.newArrayList();
    for (RewardRelParticipatorServiceObserver rewardServiceObserver : rewardRelParticipatorServiceObserverList) {
      List<RewardRelParticipatorItemVo> itemRels = rewardServiceObserver.onRequestRewardRelParticipatorItems(participatorCodes);
      if(!CollectionUtils.isEmpty(itemRels)){
        list.addAll(itemRels);
      }
    }
    //2汇总后按参与者分类
    Map<String, List<RewardRelParticipatorItemVo>> relMap = list.stream()
        .filter(item -> Objects.nonNull(item.getParticipatorCode()))
        .collect(Collectors.groupingBy(RewardRelParticipatorItemVo::getParticipatorCode));
    for (Map.Entry<String, List<RewardRelParticipatorItemVo>> entry : relMap.entrySet()) {
      RewardRelParticipatorVo vo = new RewardRelParticipatorVo();
      vo.setParticipatorCode(entry.getKey());
      List<RewardRelParticipatorItemVo> itemVos = entry.getValue();
      List<RewardTypeStatisticsVo> rewardTypeStatisticsVos = itemVos.stream()
          .map(RewardRelParticipatorItemVo::getRewardStatisticsVo)
          .collect(Collectors.toList());
      vo.setRewardTypeStatisticsVos(rewardTypeStatisticsVos);
      relList.add(vo);
    }
    return relList;
  }
}
