package com.biz.crm.admin.web.service.internal;

import com.biz.crm.admin.web.service.RewardRelScanCodeVoService;
import com.biz.crm.cps.business.agreement.sdk.dto.LoginUserAgreementDto;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementVoService;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardRelScanCodeServiceObserver;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelScanCodeItemVo;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelScanCodeVo;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author hecheng
 * @description: 奖励汇总service实现
 * @date 2021/8/24 下午6:47
 */
@Service
public class RewardRelScanCodeVoServiceImpl implements RewardRelScanCodeVoService {

  @Autowired(required = false)
  private List<RewardRelScanCodeServiceObserver> rewardRelScanCodeServiceObserverList;
  @Autowired
  private AgreementVoService agreementVoService;

  /**
   * 通过参与者 和扫码编码 查询分利信息集合 1、获取每个奖励模块的奖励信息 2、汇总后按扫码编码分类
   *
   * @param participatorCode
   * @param recordCodes
   * @return
   */
  @Override
  public List<RewardRelScanCodeVo> findByParticipatorCodeAndRecordCodes(String participatorCode, String participatorType, List<String> recordCodes) {
    if (StringUtils.isEmpty(participatorCode) || CollectionUtils.isEmpty(recordCodes) || CollectionUtils.isEmpty(rewardRelScanCodeServiceObserverList)) {
      return null;
    }
    List<RewardRelScanCodeVo> relList = Lists.newArrayList();
    // 1、======
    List<RewardRelScanCodeItemVo> list = Lists.newArrayList();
    for (RewardRelScanCodeServiceObserver rewardServiceObserver : rewardRelScanCodeServiceObserverList) {
      List<RewardRelScanCodeItemVo> rewardRelScanCodeItemVos = rewardServiceObserver.onRequestRewardRelScanCodeItems(participatorCode, recordCodes);
      if (!CollectionUtils.isEmpty(rewardRelScanCodeItemVos)) {
        list.addAll(rewardRelScanCodeItemVos);
      }
    }
    // 2、======
    Map<String, List<RewardRelScanCodeItemVo>> relMap = list.stream().collect(Collectors.groupingBy(RewardRelScanCodeItemVo::getRecordCode));
    for (Map.Entry<String, List<RewardRelScanCodeItemVo>> entry : relMap.entrySet()) {
      RewardRelScanCodeVo vo = new RewardRelScanCodeVo();
      vo.setRecordCode(entry.getKey());
      List<RewardRelScanCodeItemVo> itemVos = entry.getValue();
      if(CollectionUtils.isEmpty(itemVos)){
        continue;
      }
      itemVos.forEach(item -> {
        List<String> templateCodes = item.getTemplateCodes();
        //模版对应的协议名称
        LoginUserAgreementDto dao = new LoginUserAgreementDto();
        if (Objects.equals(participatorType, ParticipatorTypeEnum.DEALER.getDictCode())) {
          dao.setCustomerCode(participatorCode);
        } else if (Objects.equals(participatorType, ParticipatorTypeEnum.TERMINAL.getDictCode())) {
          dao.setTerminalCode(participatorCode);
        }
        if(!CollectionUtils.isEmpty(templateCodes)){
          dao.setTemplateCodes(Lists.newArrayList(templateCodes));
          List<AgreementVo> agreementVos = this.agreementVoService.findByConditions(dao);
          if(!CollectionUtils.isEmpty(agreementVos)){
            String agreementNames = agreementVos.stream().map(AgreementVo::getAgreementName).collect(Collectors.joining(","));
            item.setAgreementNames(agreementNames);
            if(!CollectionUtils.isEmpty(item.getPolicyNames())){
              String[] unitArr = new String[item.getPolicyNames().size()];
              item.getPolicyNames().toArray(unitArr);
              String policyNameStr = StringUtils.joinWith(",",unitArr);
              item.setPolicyNameStr(policyNameStr);
            }
          }
        }
      });
      vo.setRewardRelScanCodeItemVos(itemVos);
      relList.add(vo);
    }

    return relList;
  }
}
