package com.biz.crm.admin.web.service.internal;

import com.biz.crm.admin.web.service.RewardRelTriggerObjectVoService;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardRelTriggerObjectServiceObserver;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelTriggerObjectItemVo;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelTriggerObjectVo;
import com.biz.crm.cps.business.reward.sdk.vo.RewardTypeStatisticsVo;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/**
 * @author hecheng
 * @description:  分利协议汇总奖励报表service
 * @date 2021/9/2 下午7:02
 */
@Service
public class RewardRelTriggerObjectVoServiceImpl implements RewardRelTriggerObjectVoService {
  @Autowired(required = false)
  private List<RewardRelTriggerObjectServiceObserver> triggerObjectServiceObservers;

  @Override
  public List<RewardRelTriggerObjectVo> findByTriggerActionAndTriggerObjects(String triggerAction, List<String> triggerObjects) {
    if (CollectionUtils.isEmpty(triggerObjects) || StringUtils.isBlank(triggerAction) || CollectionUtils.isEmpty(triggerObjectServiceObservers)) {
      return null;
    }
    List<RewardRelTriggerObjectVo> relList = Lists.newArrayList();

    //1.获取每个奖励模块的奖励信息
    List<RewardRelTriggerObjectItemVo> list = Lists.newArrayList();
    for (RewardRelTriggerObjectServiceObserver rewardServiceObserver : triggerObjectServiceObservers) {
      List<RewardRelTriggerObjectItemVo> itemRels = rewardServiceObserver.onRequestRewardRelTriggerObjectItems(triggerAction, triggerObjects);
      if (!CollectionUtils.isEmpty(itemRels)) {
        list.addAll(itemRels);
      }
    }
    //2.汇总后按合同分类
    Map<String, List<RewardRelTriggerObjectItemVo>> relMap = list.stream().collect(Collectors.groupingBy(RewardRelTriggerObjectItemVo::getTriggerObject));
    for (Map.Entry<String, List<RewardRelTriggerObjectItemVo>> entry : relMap.entrySet()) {
      RewardRelTriggerObjectVo vo = new RewardRelTriggerObjectVo();
      vo.setTriggerObject(entry.getKey());
      List<RewardRelTriggerObjectItemVo> itemVos = entry.getValue();
      List<RewardTypeStatisticsVo> rewardTypeStatisticsVos = itemVos.stream().map(RewardRelTriggerObjectItemVo::getRewardStatisticsVo).collect(Collectors.toList());
      vo.setRewardTypeStatisticsVos(rewardTypeStatisticsVos);
      relList.add(vo);
    }
    return relList;
  }

}
