package com.biz.crm.admin.web.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.ScanCodeAgreementReportDto;
import com.biz.crm.admin.web.service.RewardRelScanCodeVoService;
import com.biz.crm.admin.web.service.ScanCodeAgreementReportVoService;
import com.biz.crm.admin.web.vo.ScanCodeAgreementReportVo;
import com.biz.crm.cps.business.agreement.local.entity.Agreement;
import com.biz.crm.cps.business.agreement.local.service.AgreementService;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementDto;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelScanCodeItemVo;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelScanCodeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

/**
 * 扫码协议报表service实现
 * @author songjingen
 */
@Service
public class ScanCodeAgreementReportVoServiceImpl implements ScanCodeAgreementReportVoService {

  @Autowired
  private AgreementService agreementService;

  @Autowired
  private RewardRelScanCodeVoService rewardRelScanCodeVoService;

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;


  /**
   * 扫码协议报表分页查询
   * @param
   * @param pageable
   * @param dto
   * @return
   */
  @Override
  public Page<ScanCodeAgreementReportVo> findByConditions(Pageable pageable, ScanCodeAgreementReportDto dto) {
    /**
     * 1、查询当前扫码编码的协议模板
     * 2、查询协议信息
     * 3、转成vo返回
     */
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (dto == null) {
      dto = new ScanCodeAgreementReportDto();
    }
    // 1、======
    List<String> codes = this.findTemplateCodesByScanCodeAgreementReportDto(dto);
    if (CollectionUtils.isEmpty(codes)) {
      return null;
    }
    // 2、======
    AgreementDto agreementDto = new AgreementDto();
    String participatorType = dto.getParticipatorType();
    String scanParticipatorCode = dto.getScanParticipatorCode();
    if (ParticipatorTypeEnum.DEALER.getKey().equals(participatorType)) {
      agreementDto.setCustomerCode(scanParticipatorCode);
    } else if (ParticipatorTypeEnum.TERMINAL.getKey().equals(participatorType)) {
      agreementDto.setTerminalCode(scanParticipatorCode);
    }
    agreementDto.setTemplateCodes(codes);
    Page<Agreement> conditions = agreementService.findByConditions(pageable, agreementDto);
    if (Objects.isNull(conditions)) {
      return null;
    }
    // 3、======
    List<Agreement> records = conditions.getRecords();
    if (!CollectionUtils.isEmpty(records)) {
      List<ScanCodeAgreementReportVo> scanCodeAgreementReportVos = (List<ScanCodeAgreementReportVo>) this.nebulaToolkitService.copyCollectionByWhiteList(records, Agreement.class, ScanCodeAgreementReportVo.class, HashSet.class, ArrayList.class);
      Page<ScanCodeAgreementReportVo> voPage = new Page<>();
      voPage.setRecords(scanCodeAgreementReportVos);
      voPage.setCurrent(conditions.getCurrent());
      voPage.setSize(conditions.getSize());
      voPage.setTotal(conditions.getTotal());
      return voPage;
    }
    return null;
  }

  /**
   * 根据条件查询出模板编码集合
   * @param dto
   * @return
   */
  private List<String> findTemplateCodesByScanCodeAgreementReportDto(ScanCodeAgreementReportDto dto){
    if (Objects.isNull(dto)) {
     return null;
    }
    String dictCode = ParticipatorTypeEnum.getByKey(dto.getParticipatorType()).getDictCode();
    ArrayList<String> list = new ArrayList<>();
    list.add(dto.getRecordCode());
    List<RewardRelScanCodeVo> participatorCodeAndRecordCodes = this.rewardRelScanCodeVoService.findByParticipatorCodeAndRecordCodes(dto.getScanParticipatorCode(), dictCode, list);
    if (CollectionUtils.isEmpty(participatorCodeAndRecordCodes)) {
      return null;
    }
    List<RewardRelScanCodeItemVo> rewardRelScanCodeItemVos = participatorCodeAndRecordCodes.get(0).getRewardRelScanCodeItemVos();
    ArrayList<String> arrayList = new ArrayList<>();
    rewardRelScanCodeItemVos.stream().forEach(rewardRelScanCodeItemVo -> {
      List<String> templateCodes = rewardRelScanCodeItemVo.getTemplateCodes();
      arrayList.addAll(templateCodes);
    });
    return arrayList;
  }
}
