package com.biz.crm.admin.web.service.internal;

import com.biz.crm.admin.web.service.ScanCodeRecordWarningReportVoService;
import com.biz.crm.admin.web.vo.ScanCodeRecordWarningReportVo;
import com.biz.crm.admin.web.vo.ScanCodeRecordWarningVo;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.participator.sdk.service.DealerVoService;
import com.biz.crm.cps.business.participator.sdk.service.TerminalVoService;
import com.biz.crm.cps.business.participator.sdk.vo.DealerVo;
import com.biz.crm.cps.business.participator.sdk.vo.TerminalVo;
import com.biz.crm.cps.external.barcode.local.entity.BarCodeLatestCirculation;
import com.biz.crm.cps.external.barcode.local.service.BarCodeLatestCirculationService;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeExceptionEnum;
import com.biz.crm.cps.external.barcode.sdk.service.ScanCodeRecordVoService;
import com.biz.crm.cps.external.barcode.sdk.vo.ScanCodeRecordVo;
import com.biz.crm.mdm.business.user.sdk.service.UserFeignVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.google.common.collect.Lists;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.gavaghan.geodesy.Ellipsoid;
import org.gavaghan.geodesy.GeodeticCalculator;
import org.gavaghan.geodesy.GeodeticCurve;
import org.gavaghan.geodesy.GlobalCoordinates;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

/**
 * 扫码记录预警报表Service实现
 * @Author dy
 * @DATE 2022/4/12
 **/
@Service("ScanCodeRecordWarningReportVoServiceImpl")
public class ScanCodeRecordWarningReportVoServiceImpl implements ScanCodeRecordWarningReportVoService {

  @Autowired
  private ScanCodeRecordVoService scanCodeRecordVoService;
  @Autowired
  private BarCodeLatestCirculationService barCodeLatestCirculationService;
  @Autowired
  private TerminalVoService terminalVoService;
  @Autowired
  private DealerVoService dealerVoService;
  @Autowired
  private UserFeignVoService userFeignVoService;

  @Override
  public ScanCodeRecordWarningReportVo findByRecordCode(String recordCode) {

    /*
      1. 根据扫码记录编码查询记录
      2. 获取预警类型数组
      3. 组装预警列表
     */
    if(StringUtils.isBlank(recordCode)){
      return null;
    }
    // 1
    ScanCodeRecordVo scanCodeRecordVo = scanCodeRecordVoService.findByRecordCode(recordCode);
    if(Objects.isNull(scanCodeRecordVo) || StringUtils.isBlank(scanCodeRecordVo.getScanCodeWarning())
        || ScanCodeExceptionEnum.NO.getCode().equals(scanCodeRecordVo.getScanCodeWarning())){
      return null;
    }

    // 2
    String scanCodeWarning = scanCodeRecordVo.getScanCodeWarning();
    String[] warningCodes = StringUtils.split(scanCodeWarning, "\\,");
    if(warningCodes.length == 0){
      return null;
    }

    // 获取最新的码流转数据
    BarCodeLatestCirculation barCodeLatestCirculation = barCodeLatestCirculationService.findByBarCode(scanCodeRecordVo.getBarCode());

    String scanParticipatorCode = barCodeLatestCirculation.getBarCodeParticipatorCode();
    String participatorType = barCodeLatestCirculation.getParticipatorType();
    String participatorName = this.findParticipatorNameByParticipatorCodeAndType(scanParticipatorCode,participatorType);

    ScanCodeRecordWarningReportVo scanCodeRecordWarningReportVo = new ScanCodeRecordWarningReportVo();

    StringBuilder sb = new StringBuilder();
    List<ScanCodeRecordWarningVo> scanCodeRecordWarningVoList = Lists.newArrayList();

    // 3
    for (String warningCode : warningCodes) {
      ScanCodeRecordWarningVo scanCodeRecordWarningVo = new ScanCodeRecordWarningVo();
      ScanCodeExceptionEnum scanCodeExceptionEnum = ScanCodeExceptionEnum.findByCode(warningCode);
      if(Objects.isNull(scanCodeExceptionEnum)){
        continue;
      }
      sb.append(scanCodeExceptionEnum.getType()).append(";");
      scanCodeRecordWarningVo.setScanCodeWarningDesc(scanCodeExceptionEnum.getDes());
      scanCodeRecordWarningVo.setScanCodeWarning(scanCodeExceptionEnum.getType());
      scanCodeRecordWarningVo.setScanCodeWarningCode(scanCodeExceptionEnum.getCode());

      // 如果是扫码距离预警需要给出偏移距离
      if(ScanCodeExceptionEnum.TERMINAL_SCAN_LOCATION.equals(scanCodeExceptionEnum)){
        String s = StringUtils.isAnyBlank(scanCodeRecordVo.getProvinceName(),scanCodeRecordVo.getCityName(),scanCodeRecordVo.getDistrictName())
            ? StringUtils.EMPTY : StringUtils.join(scanCodeRecordVo.getProvinceName(), scanCodeRecordVo.getCityName(), scanCodeRecordVo.getDistrictName());
        scanCodeRecordWarningVo.setScanCodeAddress(s);
        TerminalVo terminalVo = terminalVoService.findByTerminalCode(scanCodeRecordVo.getScanParticipatorCode());
        if(Objects.isNull(terminalVo)){
          continue;
        }
        scanCodeRecordWarningVo.setAddress(terminalVo.getTerminalAddress());
        if(StringUtils.isNoneBlank(scanCodeRecordVo.getLatitude(),scanCodeRecordVo.getLongitude(),terminalVo.getLatitude(),terminalVo.getLongitude())){
          GlobalCoordinates source = new GlobalCoordinates(Double.parseDouble(scanCodeRecordVo.getLatitude()), Double.parseDouble(scanCodeRecordVo.getLongitude()));
          GlobalCoordinates target = new GlobalCoordinates(Double.parseDouble(terminalVo.getLatitude()),Double.parseDouble(terminalVo.getLongitude()));
          GeodeticCurve geoCurve = new GeodeticCalculator().calculateGeodeticCurve(Ellipsoid.Sphere, source, target);
          double distance = Math.abs(geoCurve.getEllipsoidalDistance());
          scanCodeRecordWarningVo.setDistance(BigDecimal.valueOf(distance).setScale(2,BigDecimal.ROUND_HALF_DOWN));
        }
        scanCodeRecordWarningVoList.add(scanCodeRecordWarningVo);
        continue;
      }

      if(barCodeLatestCirculation != null){
        scanCodeRecordWarningVo.setParticipatorType(participatorType);
        scanCodeRecordWarningVo.setParticipatorCode(scanParticipatorCode);
        scanCodeRecordWarningVo.setParticipatorName(participatorName);
      }
      scanCodeRecordWarningVoList.add(scanCodeRecordWarningVo);
    }
    scanCodeRecordWarningReportVo.setScanCodeWarningCode(scanCodeWarning);
    scanCodeRecordWarningReportVo.setScanCodeWarning(sb.toString());
    scanCodeRecordWarningReportVo.setWarnings(scanCodeRecordWarningVoList);
    return scanCodeRecordWarningReportVo;
  }


  /**
   * 根据参与者编码和类型查询名称
   * @param participatorCode
   * @param participatorType
   * @return
   */
  private String findParticipatorNameByParticipatorCodeAndType(String participatorCode,String participatorType){
    if(ParticipatorTypeEnum.DEALER.getKey().equals(participatorType)){
      DealerVo dealerVo = dealerVoService.findByCustomerCode(participatorCode);
      return dealerVo == null ? null : dealerVo.getCustomerName();
    }else if(ParticipatorTypeEnum.TERMINAL.getKey().equals(participatorType)){
      TerminalVo terminalVo = terminalVoService.findByTerminalCode(participatorCode);
      return  terminalVo == null ? null : terminalVo.getTerminalName();
    }else if(ParticipatorTypeEnum.USER_GUIDE.getKey().equals(participatorType)){
      List<UserVo> userVos = userFeignVoService.findByUserNames(Arrays.asList(participatorCode));
      return  CollectionUtils.isEmpty(userVos) ? null : userVos.get(0).getFullName();
    }
    return null;
  }
}
