package com.biz.crm.admin.web.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.service.RewardRelParticipatorVoService;
import com.biz.crm.admin.web.service.TerminalReportService;
import com.biz.crm.admin.web.vo.TerminalReportVo;
import com.biz.crm.cps.business.participator.local.entity.Terminal;
import com.biz.crm.cps.business.participator.local.service.TerminalService;
import com.biz.crm.cps.business.participator.sdk.dto.TerminalPaginationDto;
import com.biz.crm.cps.business.participator.sdk.service.ParticipatorTagVoService;
import com.biz.crm.cps.business.participator.sdk.vo.ParticipatorTagVo;
import com.biz.crm.cps.business.reward.cost.sdk.common.CostConstant;
import com.biz.crm.cps.business.reward.redpacket.sdk.common.constant.RedPacketConstant;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelParticipatorVo;
import com.biz.crm.cps.business.reward.sdk.vo.RewardTypeStatisticsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 分利终端报表service实现
 *
 * @author hefan
 */
@Service
public class TerminalReportServiceImpl implements TerminalReportService {

  @Autowired
  private TerminalService terminalService;

  @Autowired
  private RewardRelParticipatorVoService rewardRelParticipatorVoService;

  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Autowired
  private ParticipatorTagVoService participatorTagVoService;

  @Override
  public Page<TerminalReportVo> findByConditions(Pageable pageable, TerminalPaginationDto terminalPaginationDto) {
    /**
     * 分页查询终端信息
     * 将查询出的信息拷贝到返回vo
     * 收集查询信息的code集合
     * 查询终端信息的奖励结果
     * 将奖励结果按参与者code分组
     * 将奖励结果拼装回返回vo
     */
    Page<Terminal> result = this.terminalService.findByConditions(pageable, terminalPaginationDto);
    List<Terminal> records = result.getRecords();
    Page<TerminalReportVo> page = new Page<>();
    page.setCurrent(result.getCurrent());
    page.setSize(result.getSize());
    page.setTotal(result.getTotal());
    if (CollectionUtils.isEmpty(records)) {
      return page;
    }
    Collection<TerminalReportVo> terminalReportVos = this.nebulaToolkitService.copyCollectionByBlankList(records, Terminal.class, TerminalReportVo.class, HashSet.class, LinkedList.class);
    List<String> codeList = terminalReportVos.stream()
        .map(TerminalReportVo::getTerminalCode)
        .collect(Collectors.toList());
    List<RewardRelParticipatorVo> rewardRelParticipatorVoList = this.rewardRelParticipatorVoService.findByParticipatorCodes(codeList);
    if (CollectionUtils.isEmpty(rewardRelParticipatorVoList)) {
      page.setRecords(Lists.newLinkedList(terminalReportVos));
      return page;
    }
    //标签
    Map<String, List<ParticipatorTagVo>> participatorTagMap = new HashMap<>();
    List<ParticipatorTagVo> participatorTagList = this.participatorTagVoService.findByParticipatorCodes(codeList);
    if (!CollectionUtils.isEmpty(participatorTagList)) {
      participatorTagMap = participatorTagList.stream().collect(Collectors.groupingBy(ParticipatorTagVo::getParticipatorCode));
    }
    Map<String, List<RewardRelParticipatorVo>> codeMapVoList = rewardRelParticipatorVoList.stream().collect(Collectors.groupingBy(RewardRelParticipatorVo::getParticipatorCode));
    for (TerminalReportVo reportVo : terminalReportVos) {
      //赋值标签
      List<ParticipatorTagVo> tags = participatorTagMap.get(reportVo.getTerminalCode());
      if(!CollectionUtils.isEmpty(tags)){
        String participatorTag = tags.stream().map(tag -> tag.getTagDescription()).collect(Collectors.joining(";"));
        reportVo.setTagDescription(participatorTag);
      }
     //赋值分利信息
      List<RewardRelParticipatorVo> rewardRelParticipatorVos = codeMapVoList.get(reportVo.getTerminalCode());
      if (CollectionUtils.isEmpty(rewardRelParticipatorVos)) {
        continue;
      }
      RewardRelParticipatorVo rewardRelParticipatorVo = rewardRelParticipatorVos.get(0);
      List<RewardTypeStatisticsVo> rewardTypeStatisticsVos = rewardRelParticipatorVo.getRewardTypeStatisticsVos();
      for (RewardTypeStatisticsVo rewardTypeStatisticsVo : rewardTypeStatisticsVos) {
        String key = rewardTypeStatisticsVo.getKey();
        if (CostConstant.COST_KEY.equals(key)) {
          reportVo.setCumulativeCost(rewardTypeStatisticsVo.getAmount());
        } else if ("integral".equals(key)) {
          reportVo.setCumulativeIntegral(rewardTypeStatisticsVo.getAmount());
        } else if (RedPacketConstant.REDPACKAGE_KEY.equals(key)) {
          reportVo.setCumulativeRedpacket(rewardTypeStatisticsVo.getAmount());
        }
      }
    }
    page.setRecords(Lists.newLinkedList(terminalReportVos));
    return page;
  }
}
