package com.biz.crm.admin.web.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 协议分利报表vo
 * @author songjingen
 */
@Data
@ApiModel(value = "AgreementReportVo", description = "协议分利报表vo")
public class AgreementReportVo {

  /**
   * 分利次数
   */
  @ApiModelProperty("分利次数")
  private Integer number;

  /**
   * 累计现金权益
   */
  @ApiModelProperty("累计现金权益")
  private BigDecimal cashTotal;

  /**
   * 累计费用权益
   */
  @ApiModelProperty("累计费用权益")
  private BigDecimal costTotal;

  /**
   * 累计积分权益
   */
  @ApiModelProperty("累计积分权益")
  private BigDecimal integralTotal;

  /**
   * 累计红包权益
   */
  @ApiModelProperty("累计红包权益")
  private BigDecimal redPacketTotal;

  /**
   * 累计扫码次数
   */
  @ApiModelProperty("累计扫码次数")
  private BigDecimal scanTotal;

  /**
   * 累计销售订单数
   */
  @ApiModelProperty("累计销售订单数")
  private BigDecimal orderTotal;

  /**
   * 累计销售订单金额
   */
  @ApiModelProperty("累计销售订单金额")
  private BigDecimal orderAmountTotal;
}
