package com.biz.crm.admin.web.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 协议分利报表vo
 * @author songjingen
 */
@Data
@ApiModel(value = "AgreementRewardVo", description = "协议分利报表vo")
public class AgreementRewardVo {

  /**
   * 触发动作所属政策
   */
  @ApiModelProperty(value = "政策名称")
  private String policyName;

  /**
   *
   * <pre>
   * 1、红包提现；
   * 2、惩罚扣除（可能有）；
   * 3、扫箱码；
   * 4、扫盖内码；
   * 5、扫盒码；
   * 6、包量任务分利；
   * 7、陈列任务分利；
   * 8、支付扫码分利（后续控价涉及）；
   * </pre>
   * 触发动作
   */
  @ApiModelProperty("触发动作")
  private String triggerAction;

  /**
   * 触发对象
   */
  @ApiModelProperty("触发对象")
  private String triggerObject;

  /**
   * 创建时间
   * */
  @ApiModelProperty(name = "createTime", value = "创建时间", required = true)
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  private Date createTime;

  /**
   * 奖励额度
   */
  @ApiModelProperty("奖励额度")
  private BigDecimal amount;

  /**
   * 备注
   */
  @ApiModelProperty("备注")
  private String remark;

  /**
   * 奖励类型
   */
  @ApiModelProperty("奖励类型")
  private String rewardType;
}
