package com.biz.crm.admin.web.vo;

import com.biz.crm.business.common.sdk.vo.TenantOpVo;
import com.biz.crm.cps.external.barcode.sdk.vo.ScanCodeRecordVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 关联码VO
 *
 * @author jerry7
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "AssociateBarCodeReportVo", description = "关联码VO")
public class AssociateBarCodeReportVo extends TenantOpVo {
  private static final long serialVersionUID = -5634791630387358956L;

  /**
   * 码
   */
  @ApiModelProperty("码")
  private String barCode;

  /**
   * 码类型：1-箱码，2-盒码，3-盖内码
   *
   * @see com.biz.crm.cps.external.barcode.sdk.common.enums.BarCodeTypeEnum
   */
  @ApiModelProperty("码类型：1-箱码，2-盒码，3-盖内码")
  private String barCodeType;

  /**
   * 码溯源关联扫码记录列表
   */
  @ApiModelProperty("关联扫码记录列表")
  private String associateRecords;

  /**
   * 码溯源关联扫码记录列表
   */
  @ApiModelProperty("关联扫码预警信息列表")
  private String associateRemarks;

}
