package com.biz.crm.admin.web.vo;

import com.biz.crm.business.common.sdk.vo.TenantOpVo;
import com.biz.crm.cps.business.participator.sdk.vo.ParticipatorTagVo;
import com.biz.crm.cps.external.barcode.sdk.vo.ScanCodeRecordVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 码溯源报表vo
 *
 * @author jerry7
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "barCodeTraceReportVo", description = "码溯源报表vo")
public class BarCodeTraceReportVo extends TenantOpVo {
  private static final long serialVersionUID = -5634791630387358956L;

  /**
   * 码
   */
  @ApiModelProperty("码")
  private String barCode;

  /**
   * 码类型：1-箱码，2-盒码，3-盖内码
   *
   * @see com.biz.crm.cps.external.barcode.sdk.common.enums.BarCodeTypeEnum
   */
  @ApiModelProperty("码类型：1-箱码，2-盒码，3-盖内码")
  private String barCodeType;

  /**
   * 扫码记录对应物料编码
   */
  @ApiModelProperty("扫码对应物料编码")
  private String productCode;

  /**
   * 扫码记录对应物料名称
   */
  @ApiModelProperty("扫码对应物料名称")
  private String productName;

  /**
   * 码溯源关联扫码记录列表
   */
  @ApiModelProperty("关联扫码记录列表")
  private List<ScanCodeRecordTraceVo> scanCodeRecordTraceVos;

  /**
   * 关联码记录
   */
  @ApiModelProperty("关联码列表")
  private List<AssociateBarCodeReportVo> associateBarCodeReportVos;

}
