package com.biz.crm.admin.web.vo;

import com.biz.crm.cps.business.participator.sdk.vo.ParticipatorTagVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 合同签署报表vo
 * @author songjingen
 */
@Data
@ApiModel(value = "ContractSignReportVo", description = "合同签署报表vo")
public class ContractSignReportVo {

  /**
   * 交易号
   */
  @ApiModelProperty("交易号")
  private String transactionId;

  /**
   * 合同编码
   */
  @ApiModelProperty("合同编码")
  private String contractId;

  /**
   * 合同名称
   */
  @ApiModelProperty("合同名称")
  private String contractName;

  /**
   * 签署时间
   */
  @ApiModelProperty("签署时间")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  private Date signTime;

  /**
   * 合同模版id
   */
  @ApiModelProperty("合同模版id")
  private String templateId;

  /**
   * 合同模版名称
   */
  @ApiModelProperty("合同模版名称")
  private String templateName;

  /**
   * 身份证姓名
   *
   */
  @ApiModelProperty("身份证姓名")
  private String personName;

  /**
   * 身份证账号
   *
   */
  @ApiModelProperty("身份证账号")
  private String idCard ;

  /**
   * 手机号
   */
  @ApiModelProperty("手机号")
  private String mobile;

  /**
   * 银行账户
   */
  @ApiModelProperty("银行账户")
  private String bankCardNo;

  /**
   * 身份证正面照片路径url
   */
  @ApiModelProperty("身份证正面照片路径")
  private String headPhotoPathUrl;

  /**
   * 身份证背面照片路径url
   */
  @ApiModelProperty("身份证背面照片路径")
  private String backgroundIdCardPathUrl;

  /**
   * 经销商渠道
   */
  @ApiModelProperty("经销商渠道")
  private String dealerChannelName;

  /**
   * 经销商所属组织
   */
  @ApiModelProperty("经销商所属组织")
  private String dealerOrgName;

  /**
   * 经销商所属客户组织名称
   */
  @ApiModelProperty("经销商所属客户组织名称")
  private String dealerCustomerOrgName;

  /**
   * 经销商客户编码
   */
  @ApiModelProperty("经销商客户编码")
  private String dealerCode;

  /**
   * 经销商客户名称
   */
  @ApiModelProperty("经销商客户名称")
  private String dealerName;

  /**
   * 经销商类型
   */
  @ApiModelProperty("经销商类型")
  private String dealerType;

  /**
   * 经销商关联手机号
   */
  @ApiModelProperty("经销商关联手机号")
  private String dealerContact;

  /**
   * 终端渠道
   */
  @ApiModelProperty("终端渠道")
  private String terminalChannelName;

  /**
   * 终端所属组织
   */
  @ApiModelProperty("终端所属组织")
  private String terminalOrgName;

  /**
   * 终端所属客户组织
   */
  @ApiModelProperty("终端所属客户组织")
  private String terminalCustomerOrganization;

  /**
   * 终端客户编码
   */
  @ApiModelProperty("终端客户编码")
  private String terminalCode;

  /**
   * 终端客户名称
   */
  @ApiModelProperty("终端客户名称")
  private String terminalName;

  /**
   * 分利终端类型
   */
  @ApiModelProperty("分利终端类型")
  private String terminalType;

  /**
   * 分利终端标签
   */
  @ApiModelProperty("分利终端标签")
  private String terminalTag;

  /**
   * 客户标签列表
   */
  @ApiModelProperty("客户标签列表")
  private List<ParticipatorTagVo> participatorTagVos;
}
