package com.biz.crm.admin.web.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 返利费用明细报表
 * @Author dy
 * @DATE 2022/4/22
 **/
@Data
@ApiModel(value = "CostDetailReportVo", description = "返利费用明细报表")
public class CostDetailReportVo {

  /** 费用明细编码 */
  @ApiModelProperty("费用明细编码")
  private String code;

  /** 组织编码 */
  @ApiModelProperty("组织编码")
  private String orgCode;

  /** 组织名称 */
  @ApiModelProperty("组织名称")
  private String orgName;

  /** 客户组织名称 */
  @ApiModelProperty("客户组织名称")
  private String customerOrgName;

  /** 客户组织编码 */
  @ApiModelProperty("客户组织编码")
  private String customerOrgCode;

  /** 参与者编码 */
  @ApiModelProperty("参与者编码")
  private String participatorCode;

  /** 参与者名称 */
  @ApiModelProperty("参与者名称")
  private String participatorName;

  /** 参与者类型 */
  @ApiModelProperty("参与者类型")
  private String participatorType;
  /** 手机号 */
  @ApiModelProperty("手机号")
  private String phone;

  /** 操作类型 */
  @ApiModelProperty("操作类型")
  private String rebateType;

  /** 关联业务类型 */
  @ApiModelProperty("关联业务类型")
  private String relateType;

  /** 关联业务流水号 */
  @ApiModelProperty("关联业务流水号")
  private String relateCode;
  /** 关联扫码活动 */
  @ApiModelProperty("关联扫码活动")
  private String relateActName;
  /** 协议模板编码 */
  @ApiModelProperty("协议模板编码")
  private String templateCode;
  /** 协议编码 */
  @ApiModelProperty("协议编码")
  private String agreementCode;
  /** 关联协议活动模板名称 */
  @ApiModelProperty("关联协议活动模板名称")
  private String templateName;

  /** 变动金额 */
  @ApiModelProperty(value = "变动数量")
  private BigDecimal amount;
  /** 费用余额 */
  @ApiModelProperty(value = "费用余额")
  private BigDecimal balance;

  /** 扫码记录编码 */
  @ApiModelProperty(value = "扫码记录编码")
  private String recordCode;

  /** 变更类型，1：增加 2：减少 */
  @ApiModelProperty("变更类型，1：增加 2：减少")
  private String type;

  /** 扫码政策 */
  @ApiModelProperty(value = "扫码政策")
  private String policyName;

  /** 操作时间 */
  @ApiModelProperty(value = "操作时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTime;

  /** 渠道 */
  @ApiModelProperty("渠道")
  private String channel;

  /** 终端类型 */
  @ApiModelProperty("终端类型")
  private String terminalType;

  /** 经销商类型 */
  @ApiModelProperty("经销商类型")
  private String dealerType;
}
