package com.biz.crm.admin.web.vo;

import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayCalculateTask;
import com.biz.crm.cps.business.reward.sdk.vo.RewardTypeStatisticsVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 陈列政策分利任务报表VO
 *
 * @author sunx
 * @date 2021/12/16
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "DisplayCalculateTaskReportVo", description = "陈列政策分利任务报表VO")
public class DisplayCalculateTaskReportVo extends DisplayCalculateTask {
  /** 终端类型 */
  @ApiModelProperty("终端类型")
  private String terminalType;

  /** 所属组织编码 */
  @ApiModelProperty("所属组织编码")
  private String orgCode;

  /** 所属组织名字 */
  @ApiModelProperty("所属组织名字")
  private String orgName;

  /** 所属客户组织编码 */
  @ApiModelProperty("所属客户组织编码")
  private String customerOrgCode;

  /** 所属客户组织名字 */
  @ApiModelProperty("所属客户组织名字")
  private String customerOrgName;

  /** 渠道 */
  @ApiModelProperty("渠道")
  private String channel;

  /** 渠道名字 */
  @ApiModelProperty("渠道名字")
  private String channelName;

  /** 标签 */
  @ApiModelProperty("标签")
  private String tagDesc;

  /**
   * 物料范围
   */
  @ApiModelProperty("物料范围")
  private String range;

  /**
   * 物料纬度
   */
  @ApiModelProperty("物料纬度")
  private String dimensionName;

  /** 分利数据 */
  @ApiModelProperty("分利数据")
  private List<RewardTypeStatisticsVo> rewardTypeStatisticsVos;
}
