package com.biz.crm.admin.web.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
 * 积分明细流水响应vo
 *
 * @author sunx
 * @date 2022/3/24
 */
@Data
@ApiModel(value = "IntegralReportVo", description = "积分明细流水响应vo")
public class IntegralReportVo {

  /** 积分明细编码 */
  @ApiModelProperty("积分明细编码")
  private String code;

  /** 组织编码 */
  @ApiModelProperty("组织编码")
  private String orgCode;

  /** 组织名称 */
  @ApiModelProperty("组织名称")
  private String orgName;

  /** 导购编码 */
  @ApiModelProperty("导购编码")
  private String participatorCode;

  /** 导购名称 */
  @ApiModelProperty("导购名称")
  private String participatorName;

  /** 客户类型 */
  @ApiModelProperty("客户类型")
  private String participatorType;
  /** 手机号 */
  @ApiModelProperty("手机号")
  private String phone;

  /** 操作类型 */
  @ApiModelProperty("操作类型")
  private String rebateType;

  /** 关联业务类型 */
  @ApiModelProperty("关联业务类型")
  private String relateType;

  /** 关联业务流水号 */
  @ApiModelProperty("关联业务流水号")
  private String relateCode;
  /** 关联扫码活动 */
  @ApiModelProperty("关联扫码活动")
  private String relateActName;
  /** 协议模板编码 */
  @ApiModelProperty("协议模板编码")
  private String templateCode;
  /** 协议编码 */
  @ApiModelProperty("协议编码")
  private String agreementCode;
  /** 关联协议活动模板名称 */
  @ApiModelProperty("关联协议活动模板名称")
  private String templateName;

  /** 变动金额 */
  @ApiModelProperty(value = "变动数量")
  private BigDecimal amount;
  /** 积分余额 */
  @ApiModelProperty(value = "积分余额")
  private BigDecimal balance;

  /** 扫码记录编码 */
  @ApiModelProperty(value = "扫码记录编码")
  private String recordCode;

  /** 操作时间 */
  @ApiModelProperty(value = "操作时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTime;
}
