package com.biz.crm.admin.web.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author: zengxingwang
 * @Date: 2021/9/17 14:12
 */
@Data
public class ParticipatorReportVo {

  /**
   * 分利准入时间
   */
  @ApiModelProperty("分利准入时间")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  private Date accessTime;

  /**
   * 累计现金权益
   */
  @ApiModelProperty("累计现金权益")
  private BigDecimal cashTotal;

  /**
   * 累计费用权益
   */
  @ApiModelProperty("累计费用权益")
  private BigDecimal costTotal;

  /**
   * 累计积分权益
   */
  @ApiModelProperty("累计积分权益")
  private BigDecimal integralTotal;

  /**
   * 累计红包权益
   */
  @ApiModelProperty("累计红包权益")
  private BigDecimal redPacketTotal;

  /**
   * 可用红包权益
   */
  @ApiModelProperty("可用红包权益")
  private BigDecimal redPacketAvailable;

  /**
   * 可用现金权益
   */
  @ApiModelProperty("可用现金权益")
  private BigDecimal cashAvailable;

  /**
   * 可用费用权益
   */
  @ApiModelProperty("可用费用权益")
  private BigDecimal costAvailable;

  /**
   * 可用积分权益
   */
  @ApiModelProperty("可用积分权益")
  private BigDecimal integralAvailable;

  /**
   * 累计参与协议数
   */
  @ApiModelProperty("累计参与协议数")
  private BigDecimal agreementTotal;

  /**
   * 累计扫码次数
   */
  @ApiModelProperty("累计扫码次数")
  private BigDecimal scanTotal;

  /**
   * 累计销售订单数
   */
  @ApiModelProperty("累计销售订单数")
  private BigDecimal orderTotal;

  /**
   * 累计销售订单金额
   */
  @ApiModelProperty("累计销售订单金额")
  private BigDecimal orderAmountTotal;
}
