package com.biz.crm.admin.web.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author: zengxingwang
 * @Date: 2021/9/24 10:24
 */
@Data
public class ParticipatorRewardVo {

  /**
   * 奖励类型
   */
  @ApiModelProperty("奖励类型")
  private String rewardType;

  /**
   * 奖励额度
   */
  @ApiModelProperty("奖励额度")
  private BigDecimal amount;

  /**
   * 创建时间
   * */
  @ApiModelProperty(name = "createTime", value = "创建时间", required = true)
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  private Date createTime;

  /**
   * 所属协议模板
   */
  @ApiModelProperty("所属协议模板")
  private String templateName;

  /**
   * 触发动作所属政策
   */
  @ApiModelProperty(value = "政策名称")
  private String policyName;

  /**
   * 编码
   */
  @ApiModelProperty(value = "编码")
  private String code;
}
