package com.biz.crm.admin.web.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @Author: zengxingwang
 * @Date: 2021/11/24 15:15
 */
@Data
public class QuantifyStatisticsVo {

  /**
   * 扫码产品维度标识
   */
  @ApiModelProperty("扫码产品维度标识")
  private String dimensionFlag;

  /**
   * 扫码产品维度名称
   */
  @ApiModelProperty("扫码产品维度名称")
  private String dimensionName;

  /**
   * 产品维度编码(品牌编码，产品编码，类别编码等)
   */
  @ApiModelProperty("产品维度编码)")
  private String specialCode;

  /**
   * 产品维度名称(品牌名称，产品名称等)
   */
  @ApiModelProperty("产品维度名称")
  private String specialName;

  /**
   * 实际销量
   */
  @ApiModelProperty("实际销量")
  private BigDecimal amount;

  /**
   * 实际占比
   */
  @ApiModelProperty("实际占比")
  private BigDecimal actualProportion;

  /**
   * 纬度范围
   */
  @ApiModelProperty("纬度范围")
  private String dimensionRange;
}
