package com.biz.crm.admin.web.vo;

import com.biz.crm.cps.business.participator.sdk.vo.ParticipatorTagVo;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.entity.QuantifyTask;
import com.biz.crm.cps.business.reward.sdk.vo.RewardTypeStatisticsVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 包量任务报表VO
 * @author jerry7
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "quantifyTaskReportVo", description = "包量任务统计VO")
public class QuantifyTaskReportVo extends QuantifyTask {

  /**
   * 终端类型
   */
  @ApiModelProperty("终端类型")
  private String terminalType;

  /**
   * 所属组织编码
   */
  @ApiModelProperty("所属组织编码")
  private String orgCode;

  /**
   * 所属组织名字
   */
  @ApiModelProperty("所属组织名字")
  private String orgName;

  /**
   * 所属客户组织编码
   */
  @ApiModelProperty("所属客户组织编码")
  private String cusOrgCode;

  /**
   * 所属客户组织名字
   */
  @ApiModelProperty("所属客户组织名字")
  private String cusOrgName;

  /**
   * 渠道
   */
  @ApiModelProperty("渠道")
  private String channel;

  /**
   * 渠道名字
   */
  @ApiModelProperty("渠道名字")
  private String channelName;

  /**
   * 省编码
   */
  @ApiModelProperty("省编码")
  private String provinceCode;

  /**
   * 市编码
   */
  @ApiModelProperty("市编码")
  private String cityCode;

  /**
   * 区编码
   */
  @ApiModelProperty("区编码")
  private String districtCode;

  /**
   * 省名称
   */
  @ApiModelProperty("省名称")
  private String provinceName;

  /**
   * 市名称
   */
  @ApiModelProperty("市名称")
  private String cityName;

  /**
   * 区名称
   */
  @ApiModelProperty("区名称")
  private String districtName;

  /**
   * 分利数据
   */
  private List<RewardTypeStatisticsVo> rewardTypeStatisticsVos;

  /**
   * 终端标签列表
   */
  private List<ParticipatorTagVo> participatorTagVos;

  /**
   * 终端标签名称组装回显，多个标签以逗号分隔
   */
  private String participatorTagStr;

  /**
   * 实际销量
   */
  @ApiModelProperty("实际销量")
  private BigDecimal saleActual;

  /**
   * 完成率
   */
  @ApiModelProperty("完成率")
  private BigDecimal completionRate;

  /**
   * 积分
   */
  @ApiModelProperty("积分")
  private BigDecimal integral;

  /**
   * 红包
   */
  @ApiModelProperty("红包")
  private BigDecimal redpacket;

  /**
   * 费用
   */
  @ApiModelProperty("费用")
  private BigDecimal cost;

  /**
   * 赠品
   */
  @ApiModelProperty("赠品")
  private BigDecimal gift;

  /**
   * 分利时间
   */
  @ApiModelProperty("分利时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date profitTime;

  /**
   * 分利商品列表
   */
  private List<ProfitProductVo> profitProductVos;

  /**
   * 分利商品名称组装回显，多个标签以逗号分隔
   */
  private String profitProductStr;

  /**
   * 物料范围列表
   */
  private List<MaterialRangeVo> materialRangeVos;

  /**
   * 物料范围名称组装回显，多个标签以逗号分隔
   */
  private String materialRangeStr;
}
