package com.biz.crm.admin.web.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 奖励赠品流水明细报表表vo
 *
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "RewardGiftDetailVo", description = "奖励赠品流水明细报表表vo")
public class RewardGiftDetailReportVo {

  private static final long serialVersionUID = -5387176716047899897L;

  /**
   * 赠品明细编码
   */
  @ApiModelProperty("赠品明细编码")
  private String code;

  /**
   * 赠品编码
   */
  @ApiModelProperty("赠品编码")
  private String materialCode;

  /**
   * 赠品名称
   */
  @ApiModelProperty("赠品名称")
  private String materialName;

  /**
   * 赠品数量
   */
  @ApiModelProperty("赠品数量")
  private BigDecimal amount;

  /**
   * 参与者类型
   */
  @ApiModelProperty("参与者类型（1-经销商，2-终端，3-消费者）")
  private String participatorType;

  /**
   * 参与者编码
   */
  @ApiModelProperty("参与者编码（经销商/终端/消费者）")
  private String participatorCode;

  /**
   * 参与者名称
   */
  @ApiModelProperty("参与者名称（经销商/终端/消费者）")
  private String participatorName;

  /**
   * 所属协议模板编码
   */
  @ApiModelProperty("所属协议模板编码")
  private String templateCode;

  /**
   * 所属协议模板名称
   */
  @ApiModelProperty("所属协议模板名称")
  private String templateName;

  /**
   * 触发动作所属政策
   */
  @ApiModelProperty("活动名称/政策名称")
  private String policyName;

  /**
   * 所属组织
   */
  @ApiModelProperty("所属组织")
  private String orgName;

  /**
   * 所属客户组织
   */
  @ApiModelProperty("所属客户组织")
  private String customerOrgName;

  /**
   * 所属渠道
   */
  @ApiModelProperty("所属渠道")
  private String channelName;

  /**
   * 参与者分利类型
   */
  @ApiModelProperty("参与者分利类型（经销商类型/终端类型）")
  private String type;

  /**
   * 参与者标签
   */
  @ApiModelProperty("参与者标签（终端标签/经销商标签）")
  private String tags;

  /**
   * 触发动作
   */
  @ApiModelProperty("触发动作")
  private String triggerAction;

  /**
   * 触发对象
   */
  @ApiModelProperty("触发对象(活动编码...)")
  private String triggerObject;

  /**
   * 变更时间
   */
  @ApiModelProperty(name = "createTime", value = "变更时间", required = true)
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  private Date createTime;
}
