package com.biz.crm.admin.web.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 新扫码记录报表vo
 *
 * @author sunx
 */
@Data
@ApiModel(value = "ScanCodeRecordReportAllVo", description = "新扫码记录报表vo")
public class ScanCodeRecordReportAllVo {

  /** 扫码记录编码 */
  @ApiModelProperty(value = "扫码记录编码")
  private String recordCode;
  /**
   * 扫码类型：1-入库，2-开单，3-抽奖
   *
   * @see com.biz.crm.cps.external.barcode.sdk.common.enums.ScanTypeEnum
   */
  @ApiModelProperty("扫码类型：1-入库，2-开单，3-抽奖")
  private String scanType;
  /**
   * 录入类型：1-手动，2-自动
   *
   * @see com.biz.crm.cps.external.barcode.sdk.common.enums.EnterTypeEnum
   */
  @ApiModelProperty("录入类型：1-手动，2-自动")
  private String enterType;

  /**
   * 码类型：1-箱码，2-盒码，3-盖内码
   *
   * @see com.biz.crm.cps.external.barcode.sdk.common.enums.BarCodeTypeEnum
   */
  @ApiModelProperty("码类型：1-箱码，2-盒码，3-盖内码")
  private String barCodeType;

  /** 码 */
  @ApiModelProperty(value = "码")
  private String barCode;

  /** 物料编码 */
  @ApiModelProperty(value = "物料编码")
  private String productCode;

  /** 参与者类型：(c-经销商，terminal-终端用户，consumer-消费者) */
  @ApiModelProperty("参与者类型：(c-经销商，terminal-终端用户，consumer-消费者)")
  private String participatorType;

  /** 码流转参与者编码 */
  @ApiModelProperty("码流转参与者编码")
  private String scanParticipatorCode;

  /**
   * 扫码预警
   * @see com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeExceptionEnum
   */
  @ApiModelProperty("扫码预警")
  @TableField(value = "scan_code_warning")
  private String scanCodeWarning;

  /** 省编码 */
  @ApiModelProperty("省编码")
  private String provinceCode;

  /** 省名称 */
  @ApiModelProperty("省名称")
  private String provinceName;

  /** 市编码 */
  @ApiModelProperty("市编码")
  private String cityCode;

  /** 市名称 */
  @ApiModelProperty("市名称")
  private String cityName;

  /** 区编码 */
  @ApiModelProperty("区编码")
  private String districtCode;

  /** 区名称 */
  @ApiModelProperty("区名称")
  private String districtName;

  /** 经度 */
  @ApiModelProperty("经度")
  private String longitude;

  /** 纬度 */
  @ApiModelProperty("纬度")
  private String latitude;

  /** 操作时间 */
  @ApiModelProperty(value = "操作时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTime;


  /** 物料名称 */
  @ApiModelProperty("物料名称")
  private String productName;

  /** 扫码活动编码 */
  @ApiModelProperty("扫码活动编码")
  private String scanActCode;

  /** 扫码活动 */
  @ApiModelProperty("扫码活动")
  private String scanActName;

  /** 组织 */
  @ApiModelProperty("组织")
  private String orgName;

  /** 码流转参与者 */
  @ApiModelProperty("码流转参与者")
  private String scanParticipator;

  /** 电话 */
  @ApiModelProperty("电话")
  private String phone;

  /**
   * 渠道
   */
  @ApiModelProperty("渠道")
  private String channelCode;

  /**
   * 所属客户组织名称
   */
  @ApiModelProperty(value = "所属客户组织名称")
  private String customerOrgName;

  /**
   * 终端类型
   */
  @ApiModelProperty("终端类型")
  private String terminalType;

  /**
   * 参与者标签
   */
  @ApiModelProperty("参与者标签")
  private String participatorTagDescription;

  /**
   * 经销商类型
   */
  @ApiModelProperty("经销商类型")
  private String dealerType;

  /** 扫码异常 */
  @ApiModelProperty("扫码异常")
  private String scanCodeException;

  /** 备注 */
  @ApiModelProperty("备注")
  private String remark;
}
