package com.biz.crm.admin.web.vo;

import com.biz.crm.cps.business.participator.sdk.vo.ParticipatorTagVo;
import com.biz.crm.cps.external.barcode.sdk.vo.ScanCodeRecordVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 扫码记录报表vo
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ScanCodeRecordReportVo", description = "扫码记录报表vo")
public class ScanCodeRecordReportVo extends ScanCodeRecordVo {
  private static final long serialVersionUID = -5634791630387358956L;

  /**
   * 经销商渠道
   */
  @ApiModelProperty("经销商渠道")
  private String dealerChannelName;

  /**
   * 经销商所属组织
   */
  @ApiModelProperty("经销商所属组织")
  private String dealerOrgName;

  /**
   * 经销商客户编码
   */
  @ApiModelProperty("经销商客户编码")
  private String dealerCode;

  /**
   * 经销商客户名称
   */
  @ApiModelProperty("经销商客户名称")
  private String dealerName;

  /**
   * 终端渠道
   */
  @ApiModelProperty("终端渠道")
  private String terminalChannelName;

  /**
   * 终端所属组织
   */
  @ApiModelProperty("终端所属组织")
  private String terminalOrgName;

  /**
   * 终端客户编码
   */
  @ApiModelProperty("终端客户编码")
  private String terminalCode;

  /**
   * 终端客户名称
   */
  @ApiModelProperty("终端客户名称")
  private String terminalName;

  /**
   * 消费者客户编码
   */
  @ApiModelProperty("消费者客户编码")
  private String consumerExternalId;

  /**
   * 消费者客户名称
   */
  @ApiModelProperty("消费者客户名称")
  private String consumerNickname;

  /**
   * 渠道
   */
  @ApiModelProperty("渠道")
  private String channelName;

  /**
   * 所属组织
   */
  @ApiModelProperty("所属组织")
  private String orgName;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String customerCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String customerName;

  /**
   * 终端客户所属组织名称
   */
  @ApiModelProperty("终端客户所属组织名称")
  private String customerOrganization;

  /**
   * 终端类型
   */
  @ApiModelProperty("终端类型")
  private String terminalType;

  /**
   * 经销商客户所属组织名称
   */
  @ApiModelProperty("经销商客户所属组织名称")
  private String dealerCustomerOrgName;

  /**
   * 经销商类型
   */
  @ApiModelProperty("经销商类型")
  private String customerType;

  /**
   * 客户标签
   */
  @ApiModelProperty("客户标签")
  private String tagName;

  /**
   * 客户标签列表
   */
  @ApiModelProperty("客户标签列表")
  private List<ParticipatorTagVo> participatorTagVos;

}
