package com.biz.crm.admin.web.vo;

import com.biz.crm.cps.business.participator.sdk.vo.ParticipatorTagVo;
import com.biz.crm.cps.external.barcode.sdk.vo.ScanCodeRecordVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 扫码记录溯源报表vo
 * @author jerry7
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ScanCodeRecordReportVo", description = "扫码记录报表vo")
public class ScanCodeRecordTraceVo extends ScanCodeRecordReportVo {
  private static final long serialVersionUID = -5634791630387358956L;

  /**
   * 扫码流出方类型
   */
  @ApiModelProperty("扫码流出方类型")
  private String codeOutFlowType;

  /**
   * 扫码流出方编码
   */
  @ApiModelProperty("扫码流出方编码")
  private String codeOutFlowCode;

  /**
   * 扫码流出方名称
   */
  @ApiModelProperty("扫码流出方名称")
  private String codeOutFlowName;

  /**
   * 扫码流入方类型
   */
  @ApiModelProperty("扫码流出方类型")
  private String codeInFlowType;

  /**
   * 扫码流入方编码
   */
  @ApiModelProperty("扫码流出方编码")
  private String codeInFlowCode;

  /**
   * 扫码流入方名称
   */
  @ApiModelProperty("扫码流出方名称")
  private String codeInFlowName;

}
