package com.biz.crm.admin.web.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 扫码记录预警vo
 * @Author dy
 * @DATE 2022/4/12
 **/
@Data
@ApiModel("扫码记录预警vo")
public class ScanCodeRecordWarningVo implements Serializable {

  private static final long serialVersionUID = -4340124021678701248L;

  @ApiModelProperty("扫码预警")
  private String scanCodeWarning;

  @ApiModelProperty("预警描述")
  private String scanCodeWarningDesc;

  @ApiModelProperty("扫码预警编码")
  private String scanCodeWarningCode;

  /**
   * 参与者类型：(c-经销商，terminal-终端用户，consumer-消费者)
   */
  @ApiModelProperty("参与者类型：(c-经销商，terminal-终端用户，consumer-消费者)")
  private String participatorType;

  /**
   * 码流转参与者编码
   */
  @ApiModelProperty("码流转参与者编码")
  private String participatorCode;

  /**
   * 码流转参与者编码
   */
  @ApiModelProperty("码流转参与者名称")
  private String participatorName;

  /**
   * 扫码位置
   */
  @ApiModelProperty("扫码位置")
  private String scanCodeAddress;

  /**
   * 位置(终端位置或经销商位置)
   */
  @ApiModelProperty("位置")
  private String address;


  /**
   * 扫码偏差距离
   */
  @ApiModelProperty("扫码偏差距离")
  private BigDecimal distance;
}
