package com.biz.crm.admin.web.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 分利统计信息VO
 *
 * @author sunx
 * @date 2021/12/16
 */
@Data
@ApiModel("分利统计信息VO")
public class ShareProfitStatisticsVo {

  /** 分利名称 */
  @ApiModelProperty("分利名称")
  private String shareProfitName;

  /** 数量 */
  @ApiModelProperty("数量")
  private BigDecimal quantity;

  /** 分利时间 */
  @ApiModelProperty("分利时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTime;
}
