package com.biz.crm.admin.web.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import lombok.Data;

/**
 * 任务扫码数据统计信息VO
 *
 * @author sunx
 * @date 2021/12/16
 */
@Data
@ApiModel("任务扫码数据统计信息VO")
public class TaskScanCodeStatisticsVo {
  /** 是否绑定销量目标 */
  @ApiModelProperty("是否绑定销量目标")
  private Boolean bindSaleFlag;

  /** 销量目标 */
  @ApiModelProperty("销量目标")
  private BigDecimal saleTarget;

  /** 实际销量 */
  @ApiModelProperty("实际销量")
  private BigDecimal saleActual;

  /** 完成比例 */
  @ApiModelProperty("完成比例")
  private BigDecimal rate;

  /** 扫码产品维度名称 */
  @ApiModelProperty("扫码产品维度名称")
  private String dimensionName;

  /** 物料范围 */
  @ApiModelProperty("物料范围")
  private String range;
}
