package com.biz.crm.admin.web.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.biz.crm.cps.business.participator.local.entity.ContactPerson;
import com.biz.crm.cps.business.participator.local.entity.SupplyRelationship;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;

/**
 * 分利终端报表vo
 * @author hefan
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TerminalReportVo", description = "分利终端信息")
public class TerminalReportVo extends TenantFlagOpVo {

  /**
   * name = "terminal_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 分利终端编码 '"
   */
  @ApiModelProperty("分利终端编码")
  private String terminalCode;

  /**
   * name = "terminal_name", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 分利终端名称 '"
   */
  @ApiModelProperty("分利终端名称")
  private String terminalName;

  /**
   * name = "terminal_type", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 分利终端类型 '"
   */
  @ApiModelProperty("分利终端类型")
  private String terminalType;

  /**
   * name = "organization", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 所属组织 '"
   */
  @ApiModelProperty("所属组织")
  private String organization;

  /**
   * name = "organization_code", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 所属组织code '"
   */
  @ApiModelProperty("所属组织code")
  private String organizationCode;

  /**
   * name = "customer_organization", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 客户组织 '"
   */
  @ApiModelProperty("客户组织")
  private String customerOrganization;

  /**
   * name = "customer_organization_code", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 客户组织Code '"
   */
  @ApiModelProperty("客户组织Code")
  private String customerOrganizationCode;

  /**
   * name = "channel", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 渠道 '"
   */
  @ApiModelProperty("渠道")
  private String channel;

  /**
   * name = "channel_name", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 渠道名称 '"
   */
  @ApiModelProperty("渠道")
  private String channelName;

  /**
   * @Column(name = "legal_person_s_name", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 营业执照法人姓名 '")
   */
  @ApiModelProperty("营业执照法人姓名")
  private String legalPersonSName;

  /**
   *   @Column(name = "registration_number", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 营业执照注册号 '")
   */
  @ApiModelProperty("营业执照注册号")
  private String registrationNumber;

  /**
   *   @Column(name = "company_name", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 营业执照企业名称 '")
   */
  @ApiModelProperty("营业执照企业名称")
  private String companyName;

  /**
   *   @Column(name = "province_code", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '省编码'")
   */
  @ApiModelProperty("省编码")
  private String provinceCode;

  /**
   *   @Column(name = "province_name", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '省名称'")
   */
  @ApiModelProperty("省名称")
  private String provinceName;

  /**
   *   @Column(name = "city_code", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '市编码'")
   */
  @ApiModelProperty("市编码")
  private String cityCode;

  /**
   *   @Column(name = "city_name", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '市名称'")
   */
  @ApiModelProperty("市名称")
  private String cityName;

  /**
   *   @Column(name = "district_code", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '区编码'")
   */
  @ApiModelProperty("区编码")
  private String districtCode;

  /**
   *   @Column(name = "district_name", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '区名称'")
   */
  @ApiModelProperty("区名称")
  private String districtName;

  /**
   *   @Column(name = "terminal_address", length = 128, nullable = true, columnDefinition = "varchar(128) COMMENT '终端地址'")
   */
  @ApiModelProperty("终端地址")
  private String terminalAddress;

  /**
   *   @Column(name = "shop_sign_path", length = 255, nullable = true, columnDefinition = "varchar(255) COMMENT '店招照片文件夹'")
   */
  @ApiModelProperty("店招照片文件夹")
  private String shopSignPath;

  /**
   *   @Column(name = "shop_sign_filename", length = 255, nullable = true, columnDefinition = "varchar(255) COMMENT '店招照片文件名'")
   */
  @ApiModelProperty("店招照片文件名")
  private String shopSignFilename;

  /**
   *   @Column(name = "business_license_path", length = 255, nullable = true, columnDefinition = "varchar(255) COMMENT '营业执照照片文件夹'")
   */
  @ApiModelProperty("营业执照照片文件夹")
  private String businessLicensePath;

  /**
   *   @Column(name = "business_license_filename", length = 255, nullable = true, columnDefinition = "varchar(255) COMMENT '营业执照照片文件名'")
   */
  @ApiModelProperty("营业执照照片文件名")
  private String businessLicenseFilename;

  /**
   *   @Column(name = "audit_status", nullable = false, columnDefinition = "VARCHAR(11) COMMENT ' 审核状态 '")
   */
  @ApiModelProperty("审核状态")
  private String auditStatus;

  /**
   *   @Column(name = "superior_customer", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 上级客户 '")
   */
  @ApiModelProperty("上级客户")
  private String superiorCustomer;

  /**
   * @Column(name = "location", length = 128, note = "经纬度 格式（纬度,经度）")
   */
  @ApiModelProperty("经纬度 格式（纬度,经度）")
  private String location;

  /**
   * @Column(name = "longitude", length = 64, note = "经度")
   */
  @ApiModelProperty("经度")
  private String longitude;

  /**
   * @Column(name = "latitude", length = 64, note = "纬度")
   */
  @ApiModelProperty("纬度")
  private String latitude;

  /**
   * openId 只在注册终端时，用于回显数据时使用
   * @Column(name = "open_id", length = 64)
   */
  @ApiModelProperty("openId")
  private String openId;

  @ApiModelProperty("营业执照法人身份证")
  private String legalPersonSId;

  @ApiModelProperty("验证码")
  private String verificationCode;

  /**
   * 联系人信息
   *   @OneToMany(fetch = FetchType.LAZY,mappedBy = "terminal")
   */
  @ApiModelProperty("联系人信息")
  private Set<ContactPerson> contactPersons;

  /**
   * 供货关系
   *   @OneToMany(fetch = FetchType.LAZY,mappedBy = "terminal")
   */
  @ApiModelProperty("供货关系")
  private Set<SupplyRelationship> supplyRelationships;

  @ApiModelProperty("提交时间")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  private Date submitTime;

  @ApiModelProperty("审核时间")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  private Date auditTime;

  @ApiModelProperty("驳回时间")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  private Date rejectTime;

  /**
   *   @Column(name = "access_time", nullable = false, columnDefinition = "datetime COMMENT '分利准入时间'")
   * */
  @ApiModelProperty("分利准入时间")
  private Date accessTime;

  /**
   *   @Column(name = "cumulative_amount", nullable = false, precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 累计分利金额 '")
   */
  @ApiModelProperty("累计分利金额")
  private BigDecimal cumulativeAmount;

  /**
   *   @Column(name = "cumulative_integral", nullable = false, precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 累计分利积分 '")
   */
  @ApiModelProperty("累计分利积分")
  private BigDecimal cumulativeIntegral;

  @ApiModelProperty("累计分利费用")
  private BigDecimal cumulativeCost;

  @ApiModelProperty("累计分利红包")
  private BigDecimal cumulativeRedpacket;

  /**
   *   @Column(name = "share_profit_status", nullable = false, columnDefinition = "INT(11) COMMENT ' 分利状态 启用:1、禁用:0 '")
   */
  @ApiModelProperty("分利状态 启用:1、禁用:0")
  private Integer shareProfitStatus;

  /**
   *   @Column(name = "virtual_account_opening_status", nullable = false, columnDefinition = "INT(11) COMMENT ' 虚拟账户开通状态 '")
   */
  @ApiModelProperty("虚拟账户开通状态")
  private Integer virtualAccountOpeningStatus;

  @ApiModelProperty("标签")
  private String tagDescription;

  /**
   * name = "terminal_source", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 分利终端来源 '"
   */
  @ApiModelProperty("分利终端来源")
  private String terminalSource;
}
