package com.biz.crm.cps.mobile.terminal;

import lombok.extern.slf4j.Slf4j;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.env.Environment;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

import java.net.UnknownHostException;

/**
 * H5启动类
 * @author songjingen
 */
@EnableFeignClients(basePackages = "com.biz.crm.*")
@ComponentScan(basePackages = {"com.bizunited.nebula.*","com.biz.crm.*"})
@SpringBootApplication(scanBasePackages = {"com.bizunited.nebula.*","com.biz.crm.*"})
@MapperScan(value={"com.biz.crm.**.mapper*"})
@EnableSwagger2
@EnableTransactionManagement
@Slf4j
public class CpsMobileTerminalApplication {

  public static void main(String[] args) throws UnknownHostException {
    System.setProperty("es.set.netty.runtime.available.processors", "false");
    ConfigurableApplicationContext application = SpringApplication.run(CpsMobileTerminalApplication.class, args);
    Environment env = application.getEnvironment();
    String port = env.getProperty("server.port");
    String path = env.getProperty("server.servlet.context-path");
    log.info("\n----------------------------------------------------------\n\t" +
            "Application crm-cps is running! Access URLs:\n\t" +
            "本地访问地址: \t\thttp://localhost:" + port + path + "/\n\t" +
            "swagger地址: \t\thttp://localhost:" + port + path + "/doc.html\n" +
            "----------------------------------------------------------");
  }
}
