package com.biz.crm.cps.mobile.terminal.config;

import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import org.springframework.context.annotation.Primary;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.web.authentication.WebAuthenticationDetails;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;

/**
 * 为CRM系统请求提供默认对象
 *
 * @author pengxi
 */
@Primary
@Component("authenticationDetailsSource")
public class DefaultAuthenticationDetailsSource implements AuthenticationDetailsSource<HttpServletRequest, WebAuthenticationDetails> {

  @Override
  public WebAuthenticationDetails buildDetails(HttpServletRequest context) {
    return new LoginUserDetailsForCPS(context);
  }

}