package com.biz.crm.cps.mobile.terminal.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementDto;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.mobile.terminal.service.AgreementReportVoService;
import com.biz.crm.cps.mobile.terminal.vo.AgreementReportVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 分利协议信息报表相关的http接口
 * @author songjingen
 */
@Slf4j
@RestController
@RequestMapping("/v1/agreement/agreementReport")
@Api(tags = "分利协议信息报表（移动端）")
public class AgreementReportVoController {

  @Autowired
  private AgreementReportVoService agreementReportVoService;

  /**
   * H5分利协议信息分页条件查询
   * @param dto
   * @return
   */
  @ApiOperation(value = "H5分利协议信息分页条件查询")
  @GetMapping("/findByConditions")
  public Result<Page<AgreementReportVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                          @ApiParam(name = "dto", value = "分利协议信息分页条件查询dto") AgreementDto dto) {
    try {
      Page<AgreementReportVo> page =  agreementReportVoService.findByConditions(pageable,dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
