package com.biz.crm.cps.mobile.terminal.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.mobile.terminal.dto.CashRecordReportDto;
import com.biz.crm.cps.mobile.terminal.service.CashRecordReportVoService;
import com.biz.crm.cps.mobile.terminal.vo.CashRecordReportVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 兑付记录信息http接口
 *
 * @author hecheng
 */
@Api(tags = "兑付记录信息")
@Slf4j
@RestController
@RequestMapping("/v1/cashRecord/cashRecordReport")
public class CashRecordReportVoController {

  @Autowired
  private CashRecordReportVoService cashRecordReportVoService;

  /**
   * 查询终端兑现流水的基本信息
   *
   * @param dto
   * @return
   */
  @ApiOperation(value = "只是（分页）查询终端兑现流水的基本信息")
  @GetMapping(value = "/findTerminalByConditions")
  public Result<Page<CashRecordReportVo>> findTerminalByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
          @ApiParam(name = "dto", value = "兑现流水Dto") CashRecordReportDto dto) {
    try {
      Page<CashRecordReportVo> listByPage = cashRecordReportVoService.findTerminalByConditions(pageable, dto);
      return Result.ok(listByPage);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 查询经销商兑现流水的基本信息s
   *
   * @param dto
   * @return
   */
  @ApiOperation(value = "只是（分页）查询经销商兑现流水的基本信息")
  @GetMapping(value = "/findDealerByConditions")
  public Result<Page<CashRecordReportVo>> findDealerByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
          @ApiParam(name = "dto", value = "兑现流水Dto") CashRecordReportDto dto) {
    try {
      Page<CashRecordReportVo> listByPage = cashRecordReportVoService.findDealerByConditions(pageable, dto);
      return Result.ok(listByPage);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 查询消费者兑现流水的基本信息
   *
   * @param dto
   * @return
   */
  @ApiOperation(value = "只是（分页）查询消费者兑现流水的基本信息")
  @GetMapping(value = "/findConsumerByConditions")
  public Result<Page<CashRecordReportVo>> findConsumerByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
          @ApiParam(name = "dto", value = "兑现流水Dto") CashRecordReportDto dto) {
    try {
      Page<CashRecordReportVo> listByPage = cashRecordReportVoService.findConsumerByConditions(pageable, dto);
      return Result.ok(listByPage);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 查询导购兑现流水的基本信息
   *
   * @param dto
   * @return
   */
  @ApiOperation(value = "只是（分页）查询导购兑现流水的基本信息")
  @GetMapping(value = "/findUserGuideByConditions")
  public Result<Page<CashRecordReportVo>> findUserGuideByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                   @ApiParam(name = "dto", value = "兑现流水Dto") CashRecordReportDto dto) {
    try {
      Page<CashRecordReportVo> listByPage = cashRecordReportVoService.findUserGuideByConditions(pageable, dto);
      return Result.ok(listByPage);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
