package com.biz.crm.cps.mobile.terminal.controller;

import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.mobile.terminal.service.ConsumerIncreaseReportVoService;
import com.biz.crm.cps.mobile.terminal.vo.ConsumerIncreaseReportVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 消费者新增报表控制器
 * @Author dy
 * @DATE 2022/3/26
 **/
@Api(tags = "消费者新增报表:ConsumerIncreaseReportVo:消费者新增报表")
@Slf4j
@RestController
@RequestMapping("/v1/mobile/consumerIncreaseReport")
public class ConsumerIncreaseReportVoController {

  @Autowired
  private ConsumerIncreaseReportVoService consumerIncreaseReportVoService;

  /**
   * 通过当前登录用户查询关联的消费者新增报表
   * @return
   */
  @ApiOperation(value = "查询当前登陆者查询")
  @GetMapping(value = "/findByCurrentUser")
  public Result<ConsumerIncreaseReportVo> findByCurrentUser() {
    try {
      ConsumerIncreaseReportVo vo = consumerIncreaseReportVoService.findByCurrentUser();
      return Result.ok(vo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
