package com.biz.crm.cps.mobile.terminal.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.consumer.sdk.dto.ConsumerDto;
import com.biz.crm.cps.mobile.terminal.service.ConsumerManageVoService;
import com.biz.crm.cps.mobile.terminal.vo.ConsumerManageVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 消费者管理控制器
 * @Author dy
 * @DATE 2022/3/26
 **/
@Api(tags = "消费者管理控制器:ConsumerManageVo:消费者管理控制器")
@Slf4j
@RestController
@RequestMapping("/v1/mobile/consumerManageVo")
public class ConsumerManageVoController {

  @Autowired
  private ConsumerManageVoService consumerManageVoService;

  /**
   * 通过当前登录用户查询关联的消费者信息
   *
   * @param dto
   * @return
   */
  @ApiOperation(value = "通过当前登录用户查询关联的消费者信息")
  @GetMapping(value = "/findByConditions")
  public Result<Page<ConsumerManageVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                         @ApiParam(name = "dto", value = "消费者分页查询dto") ConsumerDto dto) {
    try {
      Page<ConsumerManageVo> page = consumerManageVoService.findByConditions(pageable,dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
