package com.biz.crm.cps.mobile.terminal.controller;

import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelAgreementVo;
import com.biz.crm.cps.mobile.terminal.service.RewardRelAgreementVoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 奖励汇总报表报表相关http
 *
 * @author hecheng
 */
@Api(tags = "按分利协议汇总奖励报表（移动端）")
@Slf4j
@RestController
@RequestMapping("/v1/mobile/rewardRelAgreement")
public class RewardRelAgreementVoController {

  @Autowired
  private RewardRelAgreementVoService rewardRelAgreementVoService;
  @Autowired(required = false)
  private LoginUserService loginUserService;

  @ApiOperation(value = "累计收益统计")
  @GetMapping(value = "/findByAgreementCodes")
  public Result<List<RewardRelAgreementVo>> findByAgreementCodes(@RequestParam("agreementCodes") List<String> agreementCodes) {
    try {
      LoginUserDetailsForCPS userDetails = loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
      List<RewardRelAgreementVo> list = this.rewardRelAgreementVoService.findByParticipatorCodeAndTemplateCodes(userDetails.getConsumerCode(), agreementCodes);
      return Result.ok(list);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}

