package com.biz.crm.cps.mobile.terminal.controller;

import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelParticipatorVo;
import com.biz.crm.cps.mobile.terminal.service.RewardRelParticipatorVoService;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 按参与者统计奖励汇总报表报表相关http
 *
 * @author hecheng
 */
@Api(tags = "按参与者统计奖励汇总报表（移动端）")
@Slf4j
@RestController
@RequestMapping("/v1/mobile/rewardRelParticipator")
public class RewardRelParticipatorVoController {

  @Autowired
  private RewardRelParticipatorVoService rewardRelParticipatorVoService;
  @Autowired(required = false)
  private LoginUserService loginUserService;


  @ApiOperation(value = "参与者扫码奖励统计")
  @GetMapping(value = "/findByParticipatorCodes")
  public Result<List<RewardRelParticipatorVo>> findByParticipatorCodes(@RequestParam("participatorCodes") List<String> participatorCodes) {
    try {
      List<RewardRelParticipatorVo> list = Lists.newArrayList();
      if (!CollectionUtils.isEmpty(participatorCodes)) {
        list = this.rewardRelParticipatorVoService.findByParticipatorCodes(participatorCodes);
      }
      return Result.ok(list);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


  @ApiOperation(value = "查询当前登陆者 获利统计")
  @GetMapping(value = "/findByCurrentUser")
  public Result<RewardRelParticipatorVo> findByCurrentUser() {
    try {
      LoginUserDetailsForCPS userDetails = this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
      List<RewardRelParticipatorVo> list = this.rewardRelParticipatorVoService.findByParticipatorCodes(Lists.newArrayList(userDetails.getConsumerCode()));
      RewardRelParticipatorVo vo = null;
      if(!CollectionUtils.isEmpty(list)){
        vo = list.stream().findAny().orElse(null);
      }
      return Result.ok(vo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}

