package com.biz.crm.cps.mobile.terminal.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.cps.mobile.terminal.service.RewardReportVoService;
import com.biz.crm.cps.mobile.terminal.vo.RewardReportVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 奖励报表: RewardReportVo: 奖励报表
 *
 * @author sunx
 * @date 2022/3/28
 */
@Api(tags = "奖励报表: RewardReportVo: 奖励报表")
@Slf4j
@RestController
@RequestMapping("/v1/reward/rewardReportVoController")
public class RewardReportVoController {

  @Autowired private RewardReportVoService rewardReportVoService;

  /**
   * 根据扫码记录编码获取分利返利明细
   *
   * @param recordCode
   * @return
   */
  @GetMapping("/findByRecordCode")
  @ApiOperation("根据扫码记录编码获取分利返利明细")
  public Result<List<RewardReportVo>> findByRecordCode(
      @RequestParam("recordCode") String recordCode) {
    try {
      return Result.ok(this.rewardReportVoService.findByRecordCode(recordCode));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
