package com.biz.crm.cps.mobile.terminal.controller;

import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.reward.sdk.vo.RewardTypeStatisticsVo;
import com.biz.crm.cps.mobile.terminal.service.RewardTypeStatisticsVoService;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 奖励汇总报表报表相关http
 *
 * @author hecheng
 */
@Api(tags = "奖励汇总报表（移动端）")
@Slf4j
@RestController
@RequestMapping("/v1/mobile/rewardTypeStatistics")
public class RewardTypeStatisticsVoController {

  @Autowired
  private RewardTypeStatisticsVoService rewardTypeStatisticsVoService;
  @Autowired(required = false)
  private LoginUserService loginUserService;

  @ApiOperation(value = "扫码奖励统计")
  @GetMapping(value = "/findByRecordCodes")
  public Result<List<RewardTypeStatisticsVo>> findByRecordCodes(@RequestParam("recordCodes") List<String> recordCodes) {
    try {
      List<RewardTypeStatisticsVo> list = Lists.newArrayList();
      if (!CollectionUtils.isEmpty(recordCodes)) {
        LoginUserDetailsForCPS userDetails = loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
        list = this.rewardTypeStatisticsVoService.findByParticipatorCodeAndRecordCodes(userDetails.getConsumerCode(), recordCodes);
      }
      return Result.ok(list);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}

