package com.biz.crm.cps.mobile.terminal.controller;

import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.mobile.terminal.service.ScanCodeMaterialVoService;
import com.biz.crm.cps.mobile.terminal.vo.ScanCodeMaterialVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 扫码产品信息报表相关http
 *
 * @author songjingen
 */
@Api(tags = "扫码记录报表（移动端）")
@Slf4j
@RestController
@RequestMapping("/v1/mobile/scanCodeMaterialVo")
public class ScanCodeMaterialVoController {

  @Autowired
  private ScanCodeMaterialVoService scanCodeMaterialVoService;

  /**
   * 通过扫码编码集合查询扫码产品信息
   *
   * @param recordCodes
   * @return
   */
  @ApiOperation(value = "通过扫码编码集合查询扫码产品信息")
  @GetMapping(value = "/findByRecordCodes")
  public Result<List<ScanCodeMaterialVo>> findByRecordCodes(@ApiParam(name = "recordCodes", value = "扫码编码")@RequestParam List<String> recordCodes) {
    try {
      List<ScanCodeMaterialVo> page = scanCodeMaterialVoService.findByRecordCodes(recordCodes);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
