package com.biz.crm.cps.mobile.terminal.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.mobile.terminal.dto.ScanCodeRecordReportAllPaginationDto;
import com.biz.crm.cps.mobile.terminal.dto.ScanCodeRecordReportGuidePaginationDto;
import com.biz.crm.cps.mobile.terminal.service.ScanCodeRecordReportAllVoService;
import com.biz.crm.cps.mobile.terminal.vo.ScanCodeRecordReportAllVo;
import com.biz.crm.cps.mobile.terminal.vo.ScanCodeRecordReportGuideVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 扫码记录报表
 *
 * @author sunx
 * @date 2022/3/29
 */
@Api(tags = "扫码记录报表（移动端）: ScanCodeRecordReportAllVo: 扫码记录报表（移动端）")
@Slf4j
@RestController
@RequestMapping("/v1/mobile/scanCodeRecordReport")
public class ScanCodeRecordReportAllVoController {

  @Autowired private ScanCodeRecordReportAllVoService scanCodeRecordReportAllVoService;

  /**
   * 通过查询条件查询当前参与者的扫码记录分页信息(导购)
   *
   * @param dto
   * @return
   */
  @ApiOperation(value = "通过查询条件查询当前参与者的扫码记录分页信息(导购)")
  @GetMapping(value = "/findUserGuideByConditions")
  public Result<Page<ScanCodeRecordReportGuideVo>> findUserGuideByConditions(
      @ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
      @ApiParam(name = "dto", value = "扫码记录报表查询dto") ScanCodeRecordReportGuidePaginationDto dto) {
    try {
      Page<ScanCodeRecordReportGuideVo> page =
          scanCodeRecordReportAllVoService.findUserGuideByConditions(pageable, dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


  /**
   * 通过查询条件查询当前参与者的扫码记录分页信息(终端，经销商)
   *
   * @param dto
   * @return
   */
  @ApiOperation(value = "通过查询条件查询当前参与者的扫码记录分页信息(终端，经销商)")
  @GetMapping(value = "/findAllByConditions")
  public Result<Page<ScanCodeRecordReportAllVo>> findByConditions(
      @ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
      @ApiParam(name = "dto", value = "扫码记录报表查询dto") ScanCodeRecordReportAllPaginationDto dto) {
    try {
      Page<ScanCodeRecordReportAllVo> page = scanCodeRecordReportAllVoService.findByConditions(pageable, dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
