package com.biz.crm.cps.mobile.terminal.controller;

import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.mobile.terminal.dto.ScanCodeRecordReportDto;
import com.biz.crm.cps.mobile.terminal.service.ScanCodeRecordReportVoService;
import com.biz.crm.cps.mobile.terminal.vo.ScanCodeReachVo;
import com.biz.crm.cps.mobile.terminal.vo.ScanCodeStatisticsVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 扫码记录报表相关http
 *
 * @author songjingen
 */
@Api(tags = "扫码记录报表（移动端）")
@Slf4j
@RestController
@RequestMapping("/v1/mobile/scanCodeRecordReport")
public class ScanCodeRecordReportVoController {

  @Autowired
  private ScanCodeRecordReportVoService scanCodeRecordReportVoService;

  /**
   * 通过查询条件查询当前参与者的扫码记录分页信息
   *
   * @param dto
   * @return
   */
  @ApiOperation(value = "通过查询条件查询当前参与者的扫码记录分页信息")
  @GetMapping(value = "/findByConditions")
  public Result<ScanCodeStatisticsVo> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                       @ApiParam(name = "dto", value = "扫码记录报表查询dto") ScanCodeRecordReportDto dto) {
    try {
      ScanCodeStatisticsVo vo = scanCodeRecordReportVoService.findByConditions(pageable, dto);
      return Result.ok(vo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过查询条件查询当前参与者的扫码记录分页信息
   *
   * @return
   */
  @ApiOperation(value = "查询终端本月销量目标和达成率")
  @GetMapping(value = "/findScanTargetAndReach")
  public Result<List<ScanCodeReachVo>> findScanTargetAndReach(@ApiParam(name = "dateType", value = "时间类型(月month/年year)")
                                                        @RequestParam("dateType") String dateType) {
    try {
      return Result.ok(scanCodeRecordReportVoService.findScanTargetAndReach(dateType));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
