package com.biz.crm.cps.mobile.terminal.controller;

import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.mobile.terminal.service.ScanCodeRecordStatisticalVoService;
import com.biz.crm.cps.mobile.terminal.vo.ScanCodeRecordStatisticalVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 扫码记录统计控制器
 * @Author dy
 * @DATE 2022/4/15
 **/
@Api(tags = "扫码记录统计报表（移动端）: ScanCodeRecordStatisticalVo: 扫码记录统计报表（移动端）")
@Slf4j
@RestController
@RequestMapping("/v1/mobile/scanCodeRecordStatisticalVo")
public class ScanCodeRecordStatisticalVoController {

  @Autowired
  private ScanCodeRecordStatisticalVoService scanCodeRecordStatisticalVoService;


  /**
   * 通过查询条件查询当前参与者的扫码统计信息(终端，经销商)
   * @return
   */
  @ApiOperation(value = "通过查询条件查询当前参与者的扫码统计信息(终端，经销商)")
  @GetMapping(value = "/findByCurrentUser")
  public Result<ScanCodeRecordStatisticalVo> findByCurrentUser(@RequestParam(value = "scanType",required = false) @ApiParam("扫码场景") String scanType) {
    try {
      ScanCodeRecordStatisticalVo scanCodeRecordStatisticalVo = this.scanCodeRecordStatisticalVoService.findByCurrentUser(scanType);
      return Result.ok(scanCodeRecordStatisticalVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
