package com.biz.crm.cps.mobile.terminal.controller;

import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.mobile.terminal.service.ScanCodeStandardVoService;
import com.biz.crm.cps.mobile.terminal.vo.ScanCodeStandardVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 统计条码标准转换相关接口
 * @author songjingen
 */
@Api(tags = "扫码记录报表（移动端）")
@Slf4j
@RestController
@RequestMapping("/v1/mobile/scanCodeStandard")
public class ScanCodeStandardVoController {

  @Autowired
  private ScanCodeStandardVoService scanCodeStandardVoService;

  /**
   * 查询经销商月度和年度的标瓶和标箱
   * @return
   */
  @ApiOperation(value = "查询经销商月度和年度的标瓶和标箱")
  @GetMapping(value = "/findScanCodeStandardVoByDateType")
  public Result<ScanCodeStandardVo> findScanCodeStandardVoByDateType(@ApiParam(name = "dateType", value = "时间类型(月month/年year)") @RequestParam("dateType") String dateType) {
    try {
      return Result.ok(scanCodeStandardVoService.findScanCodeStandardVoByDateType(dateType));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
